package org.etsi.osl.metrico.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.*;
import lombok.Getter;
import lombok.Setter;
import org.etsi.osl.tmf.pm628.model.ExecutionStateType;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.OffsetDateTime;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;

@Getter
@Setter
@Entity
@Table(name = "MetJob")
public class Job{

    @Id
    @GeneratedValue(generator = "UUID")
    @GenericGenerator(name = "UUID", strategy = "org.hibernate.id.UUIDGenerator")
    private UUID uuid;

    private ExecutionStateType state;

    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime startDateTime;

    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime endDateTime;

    private Integer executionInterval;

    private UUID dataAccessEndPointRef; // Get the prometheus IP (uri) and its state

    private UUID scheduleDefinitionRef;  //Get the startDateTime, endDateTime and executionInterval (recurringFrequency)

    // Get the reporting period and collection granularity(the periods are too big),
    // Consuming / producing application id,
    // scheduleDefinitionRef -> Get the startDateTime, endDateTime and executionInterval (recurringFrequency)
    // Should I check the granularity or the scheduleDefinitionRef for the recurringFrequency?
    private UUID measurementCollectionJobRef;

    @JsonIgnore
    private boolean deleted = false;

    @Transient
    private final Runnable task = new Runnable() {
        @Override
        public void run() {

        }
    };

    @Transient
    private ScheduledFuture<?> future;


    public Job() {
        this.state = ExecutionStateType.PENDING;
        this.executionInterval = 10;
        this.startDateTime = OffsetDateTime.now();
    }

    public Job(OffsetDateTime stopDateTime){
        this();
        this.endDateTime = stopDateTime;
    }

    public Job(OffsetDateTime startDateTime, OffsetDateTime endDateTime){
        this(endDateTime);
        this.startDateTime = startDateTime;
    }

    public Job(OffsetDateTime startDateTime, OffsetDateTime endDateTime, Integer executionInterval){
        this(startDateTime, endDateTime);
        this.executionInterval = executionInterval;
    }

    @Override
    public String toString() {
        return "Job{" +
                "uuid=" + uuid +
                ", state=" + state +
                ", startDateTime=" + startDateTime +
                ", endDateTime=" + endDateTime +
                ", executionInterval=" + executionInterval +
                ", dataAccessEndPointRef=" + dataAccessEndPointRef +
                ", scheduleDefinitionRef=" + scheduleDefinitionRef +
                ", measurementCollectionJobRef=" + measurementCollectionJobRef +
                ", deleted=" + deleted +
                '}';
    }

}
