package org.etsi.osl.metrico.mapper;

import org.etsi.osl.tmf.pm628.model.TrackingRecord;
import org.etsi.osl.tmf.pm628.model.TrackingRecordMVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

@Mapper(uses = {
        CharacteristicMapper.class
})
public interface TrackingRecordMapper {
    TrackingRecordMapper INSTANCE = Mappers.getMapper(TrackingRecordMapper.class);

    @Mapping(source = "type", target = "type")
    @Mapping(source = "baseType", target = "baseType")
    @Mapping(source = "schemaLocation", target = "schemaLocation")
    @Mapping(source = "description", target = "description")
    @Mapping(source = "characteristic", target = "characteristic")
    @Mapping(source = "systemId", target = "systemId")
    @Mapping(source = "time", target = "time")
    @Mapping(source = "user", target = "user")
    @Mapping(source = "uuid", target = "uuid")
    TrackingRecord toTrackingRecord(TrackingRecordMVO trackingRecordMVO);

    @Mapping(source = "type", target = "type")
    @Mapping(source = "baseType", target = "baseType")
    @Mapping(source = "schemaLocation", target = "schemaLocation")
    @Mapping(source = "description", target = "description")
    @Mapping(source = "characteristic", target = "characteristic")
    @Mapping(source = "systemId", target = "systemId")
    @Mapping(source = "time", target = "time")
    @Mapping(source = "user", target = "user")
    @Mapping(source = "uuid", target = "uuid")
    TrackingRecordMVO toTrackingRecordMVO(TrackingRecord trackingRecord);
}