package org.etsi.osl.metrico.mapper;

import org.etsi.osl.tmf.pm628.model.Resource;
import org.etsi.osl.tmf.pm628.model.ResourceMVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

@Mapper(uses = {
        NoteMapper.class,
        RelatedResourceOrderItemMapper.class,
        RelatedPlaceRefMapper.class,
        RelatedPartyRefOrPartyRoleRefMapper.class,
        ResourceRelationshipMapper.class,
        CharacteristicMapper.class,
        AttachmentRefMapper.class,
        ResourceSpecificationRefMapper.class,
        FeatureMapper.class,
        IntentRefMapper.class,
        ExternalIdentifierMapper.class
})
public interface ResourceMapper {
    ResourceMapper INSTANCE = Mappers.getMapper(ResourceMapper.class);

    @Mapping(source = "type", target = "type")
    @Mapping(source = "baseType", target = "baseType")
    @Mapping(source = "schemaLocation", target = "schemaLocation")
    @Mapping(source = "href", target = "href")
    @Mapping(source = "uuid", target = "uuid")
    @Mapping(source = "category", target = "category")
    @Mapping(source = "description", target = "description")
    @Mapping(source = "name", target = "name")
    @Mapping(source = "endOperatingDate", target = "endOperatingDate")
    @Mapping(source = "administrativeState", target = "administrativeState")
    @Mapping(source = "operationalState", target = "operationalState")
    @Mapping(source = "resourceStatus", target = "resourceStatus")
    @Mapping(source = "usageState", target = "usageState")
    @Mapping(source = "validFor", target = "validFor")
    @Mapping(source = "note", target = "note")
    @Mapping(source = "resourceOrderItem", target = "resourceOrderItem")
    @Mapping(source = "place", target = "place")
    @Mapping(source = "relatedParty", target = "relatedParty")
    @Mapping(source = "resourceRelationship", target = "resourceRelationship")
    @Mapping(source = "resourceCharacteristic", target = "resourceCharacteristic")
    @Mapping(source = "attachment", target = "attachment")
    @Mapping(source = "resourceSpecification", target = "resourceSpecification")
    @Mapping(source = "startOperatingDate", target = "startOperatingDate")
    @Mapping(source = "resourceVersion", target = "resourceVersion")
    @Mapping(source = "activationFeature", target = "activationFeature")
    @Mapping(source = "intent", target = "intent")
    @Mapping(source = "externalIdentifier", target = "externalIdentifier")
    Resource toResource(ResourceMVO resourceMVO);

    @Mapping(source = "type", target = "type")
    @Mapping(source = "baseType", target = "baseType")
    @Mapping(source = "schemaLocation", target = "schemaLocation")
    @Mapping(source = "href", target = "href")
    @Mapping(source = "uuid", target = "uuid")
    @Mapping(source = "category", target = "category")
    @Mapping(source = "description", target = "description")
    @Mapping(source = "name", target = "name")
    @Mapping(source = "endOperatingDate", target = "endOperatingDate")
    @Mapping(source = "administrativeState", target = "administrativeState")
    @Mapping(source = "operationalState", target = "operationalState")
    @Mapping(source = "resourceStatus", target = "resourceStatus")
    @Mapping(source = "usageState", target = "usageState")
    @Mapping(source = "validFor", target = "validFor")
    @Mapping(source = "note", target = "note")
    @Mapping(source = "resourceOrderItem", target = "resourceOrderItem")
    @Mapping(source = "place", target = "place")
    @Mapping(source = "relatedParty", target = "relatedParty")
    @Mapping(source = "resourceRelationship", target = "resourceRelationship")
    @Mapping(source = "resourceCharacteristic", target = "resourceCharacteristic")
    @Mapping(source = "attachment", target = "attachment")
    @Mapping(source = "resourceSpecification", target = "resourceSpecification")
    @Mapping(source = "startOperatingDate", target = "startOperatingDate")
    @Mapping(source = "resourceVersion", target = "resourceVersion")
    @Mapping(source = "activationFeature", target = "activationFeature")
    @Mapping(source = "intent", target = "intent")
    @Mapping(source = "externalIdentifier", target = "externalIdentifier")
    ResourceMVO toResourceMVO(Resource resource);
}