package org.etsi.osl.metrico;

import org.etsi.osl.metrico.services.MetricoService;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJob;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJobRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import jakarta.validation.constraints.NotNull;


@SpringBootApplication
@EnableJpaRepositories("org.etsi.osl.metrico.repo")
@EntityScan( basePackages = {
        "org.etsi.osl.metrico.repo",
        "org.etsi.osl.metrico.model",
        "org.etsi.osl.metrico",
        "org.etsi.osl.metrico.reposervices",
        "org.etsi.osl.metrico.services"
})
        public class MetricoSpringBoot implements CommandLineRunner {

  private static final Logger logger =
          LoggerFactory.getLogger(MetricoSpringBoot.class.getSimpleName());

//
//  @Autowired
//  private MetricoService aMetricoService;
  
  
  @Override
  public void run(String... arg0) {
    if (arg0.length > 0 && arg0[0].equals("exitcode")) {
      throw new ExitException();
    }
    

//    @NotNull
//    MeasurementCollectionJob mcj = new MeasurementCollectionJob();
//    
//    @NotNull
//    MeasurementCollectionJobRef mjref = new MeasurementCollectionJobRef();
//    mjref.setId("268cd191-21ac-4a81-84d8-933445a65ec1");
//    aMetricoService.startPeriodicQueryToPrometheusRef(mjref );
  }
  


  public static void main(String[] args) {
    logger.info("============================== STARTING METRICO ==============================");
    ApplicationContext applicationContext = new SpringApplication(MetricoSpringBoot.class).run(args);
    
    
    
    
  }

  static class ExitException extends RuntimeException implements ExitCodeGenerator {
    private static final long serialVersionUID = 1L;
    @Override
    public int getExitCode() {
      return 10;
    }
  }

}
