package org.etsi.osl.metrico.services;

import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJob;
import org.etsi.osl.tmf.so641.model.ServiceOrderUpdate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class MetricoServiceRouteBuilder extends RouteBuilder {

    private static final transient Log logger = LogFactory.getLog(MetricoServiceRouteBuilder.class.getName());

    @Autowired
    private MetricoService metricoService;

    @Value("${PM_MEASUREMENT_COLLECTION_JOB_CREATED}")
    private String PM_MEASUREMENT_COLLECTION_JOB_CREATED = "";

    public void configure() throws Exception {

        from(PM_MEASUREMENT_COLLECTION_JOB_CREATED)
                .log(LoggingLevel.INFO, log, PM_MEASUREMENT_COLLECTION_JOB_CREATED + " message received!")
                .to("log:DEBUG?showBody=true&showHeaders=true").unmarshal()
                .json(JsonLibrary.Jackson, MeasurementCollectionJob.class, true)
                .bean(metricoService, "startPeriodicQueryToPrometheus(${body})");

    }


}
