package org.etsi.osl.metrico;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.ApplicationContext;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;


@SpringBootApplication
@EnableJpaRepositories("org.etsi.osl.metrico.repo")
@EntityScan( basePackages = {
        "org.etsi.osl.metrico.repo",
        "org.etsi.osl.metrico.model",
        "org.etsi.osl.metrico",
        "org.etsi.osl.metrico.reposervices"
})
        public class MetricoSpringBoot implements CommandLineRunner {

  private static final Logger logger =
          LoggerFactory.getLogger(MetricoSpringBoot.class.getSimpleName());


  @Override
  public void run(String... arg0) {
    if (arg0.length > 0 && arg0[0].equals("exitcode")) {
      throw new ExitException();
    }
  }

  public static void main(String[] args) {
    logger.info("============================== STARTING METRICO ==============================");
    ApplicationContext applicationContext = new SpringApplication(MetricoSpringBoot.class).run(args);
  }

  static class ExitException extends RuntimeException implements ExitCodeGenerator {
    private static final long serialVersionUID = 1L;
    @Override
    public int getExitCode() {
      return 10;
    }
  }

}
