package org.etsi.osl.metrico.repo;

import org.etsi.osl.metrico.model.Job;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;
import java.util.UUID;

@Repository
public interface JobRepository extends JpaRepository<Job, UUID> {
    @Query("SELECT j FROM Job j WHERE j.deleted = false")
    List<Job> findAllActiveJobs();

    @Query("SELECT j FROM Job j WHERE j.uuid = :id AND j.deleted = false")
    Optional<Job> findActiveById(@Param("id") UUID id);
}