package org.etsi.osl.metrico.mapper;

import org.etsi.osl.tmf.pm628.model.ResourceRelationship;
import org.etsi.osl.tmf.pm628.model.ResourceRelationshipMVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

@Mapper
public interface ResourceRelationshipMapper {
    ResourceRelationshipMapper INSTANCE = Mappers.getMapper(ResourceRelationshipMapper.class);

    @Mapping(source = "type", target = "type")
    @Mapping(source = "baseType", target = "baseType")
    @Mapping(source = "schemaLocation", target = "schemaLocation")
    @Mapping(source = "uuid", target = "uuid")
    @Mapping(source = "resourceRelationshipCharacteristic", target = "resourceRelationshipCharacteristic")
    @Mapping(source = "resource", target = "resource")
    @Mapping(source = "relationshipType", target = "relationshipType")
    ResourceRelationship toResourceRelationship(ResourceRelationshipMVO resourceRelationshipMVO);

    @Mapping(source = "type", target = "type")
    @Mapping(source = "baseType", target = "baseType")
    @Mapping(source = "schemaLocation", target = "schemaLocation")
    @Mapping(source = "uuid", target = "uuid")
    @Mapping(source = "resourceRelationshipCharacteristic", target = "resourceRelationshipCharacteristic")
    @Mapping(source = "resource", target = "resource")
    @Mapping(source = "relationshipType", target = "relationshipType")
    ResourceRelationshipMVO toResourceRelationshipMVO(ResourceRelationship resourceRelationship);
}