package org.etsi.osl.metrico.mapper;

import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJob;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJobMVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

@Mapper(uses = {
        DataFilterMapMapper.class,
        PerformanceIndicatorGroupSpecificationMapper.class,
        PerformanceIndicatorSpecificationRefOrValueMapper.class,
        TrackingRecordMapper.class,
        FileTransferDataMapper.class,
        DataAccessEndpointMapper.class,
        ScheduleDefinitionMapper.class
})
public interface MeasurementCollectionJobMapper {
    MeasurementCollectionJobMapper INSTANCE = Mappers.getMapper(MeasurementCollectionJobMapper.class);

    @Mapping(source = "reportingPeriod", target = "reportingPeriod")
    @Mapping(source = "jobCollectionFilter", target = "jobCollectionFilter")
    @Mapping(source = "searchTaskFilter", target = "searchTaskFilter")
    @Mapping(source = "jobOnDemand", target = "jobOnDemand")
    @Mapping(source = "performanceIndicatorGroupSpecification", target = "performanceIndicatorGroupSpecification")
    @Mapping(source = "performanceIndicatorSpecification", target = "performanceIndicatorSpecification")
    @Mapping(source = "trackingRecord", target = "trackingRecord")
    @Mapping(source = "fileTransferData", target = "fileTransferData")
    @Mapping(source = "dataAccessEndpoint", target = "dataAccessEndpoint")
    @Mapping(source = "scheduleDefinition", target = "scheduleDefinition")
    MeasurementCollectionJob toMeasurementCollectionJob(MeasurementCollectionJobMVO measurementCollectionJobMVO);

    @Mapping(source = "reportingPeriod", target = "reportingPeriod")
    @Mapping(source = "jobCollectionFilter", target = "jobCollectionFilter")
    @Mapping(source = "searchTaskFilter", target = "searchTaskFilter")
    @Mapping(source = "jobOnDemand", target = "jobOnDemand")
    @Mapping(source = "performanceIndicatorGroupSpecification", target = "performanceIndicatorGroupSpecification")
    @Mapping(source = "performanceIndicatorSpecification", target = "performanceIndicatorSpecification")
    @Mapping(source = "trackingRecord", target = "trackingRecord")
    @Mapping(source = "fileTransferData", target = "fileTransferData")
    @Mapping(source = "dataAccessEndpoint", target = "dataAccessEndpoint")
    @Mapping(source = "scheduleDefinition", target = "scheduleDefinition")
    MeasurementCollectionJobMVO toMeasurementCollectionJobMVO(MeasurementCollectionJob measurementCollectionJob);
}