package org.etsi.osl.metrico.mapper;

import org.etsi.osl.tmf.pm628.model.ManagementJob;
import org.etsi.osl.tmf.pm628.model.ManagementJobMVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

@Mapper(uses = {
        FileTransferDataMapper.class,
        DataAccessEndpointMapper.class,
        ScheduleDefinitionMapper.class
})
public interface ManagementJobMapper {
    ManagementJobMapper INSTANCE = Mappers.getMapper(ManagementJobMapper.class);

    @Mapping(source = "type", target = "type")
    @Mapping(source = "baseType", target = "baseType")
    @Mapping(source = "schemaLocation", target = "schemaLocation")
    @Mapping(source = "href", target = "href")
    @Mapping(source = "uuid", target = "uuid")
    @Mapping(source = "fileTransferData", target = "fileTransferData")
    @Mapping(source = "dataAccessEndpoint", target = "dataAccessEndpoint")
    @Mapping(source = "scheduleDefinition", target = "scheduleDefinition")
    ManagementJob toManagementJob(ManagementJobMVO managementJobMVO);

    @Mapping(source = "type", target = "type")
    @Mapping(source = "baseType", target = "baseType")
    @Mapping(source = "schemaLocation", target = "schemaLocation")
    @Mapping(source = "href", target = "href")
    @Mapping(source = "uuid", target = "uuid")
    @Mapping(source = "fileTransferData", target = "fileTransferData")
    @Mapping(source = "dataAccessEndpoint", target = "dataAccessEndpoint")
    @Mapping(source = "scheduleDefinition", target = "scheduleDefinition")
    ManagementJobMVO toManagementJobMVO(ManagementJob managementJob);
}