package org.etsi.osl.metrico.mapper;

import org.etsi.osl.tmf.pm628.model.Feature;
import org.etsi.osl.tmf.pm628.model.FeatureMVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

@Mapper
public interface FeatureMapper {
    FeatureMapper INSTANCE = Mappers.getMapper(FeatureMapper.class);

    @Mapping(source = "type", target = "type")
    @Mapping(source = "baseType", target = "baseType")
    @Mapping(source = "schemaLocation", target = "schemaLocation")
    @Mapping(source = "name", target = "name")
    @Mapping(source = "isBundle", target = "isBundle")
    @Mapping(source = "featureRelationship", target = "featureRelationship")
    @Mapping(source = "featureCharacteristic", target = "featureCharacteristic")
    @Mapping(source = "policyConstraint", target = "policyConstraint")
    @Mapping(source = "isEnabled", target = "isEnabled")
    Feature toFeature(FeatureMVO featureMVO);

    @Mapping(source = "type", target = "type")
    @Mapping(source = "baseType", target = "baseType")
    @Mapping(source = "schemaLocation", target = "schemaLocation")
    @Mapping(source = "name", target = "name")
    @Mapping(source = "isBundle", target = "isBundle")
    @Mapping(source = "featureRelationship", target = "featureRelationship")
    @Mapping(source = "featureCharacteristic", target = "featureCharacteristic")
    @Mapping(source = "policyConstraint", target = "policyConstraint")
    @Mapping(source = "isEnabled", target = "isEnabled")
    FeatureMVO toFeatureMVO(Feature feature);
}