package org.etsi.osl.metrico.mapper;

import org.etsi.osl.tmf.pm628.model.MeasurementJob;
import org.etsi.osl.tmf.pm628.model.MeasurementJobMVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

@Mapper(uses = {
        FileTransferDataMapper.class,
        DataAccessEndpointMapper.class,
        ScheduleDefinitionMapper.class,
        PerformanceIndicatorGroupSpecificationMapper.class,
        PerformanceIndicatorSpecificationRefOrValueMapper.class,
        TrackingRecordMapper.class
})
public interface MeasurementJobMapper {
    MeasurementJobMapper INSTANCE = Mappers.getMapper(MeasurementJobMapper.class);

    @Mapping(source = "consumingApplicationId", target = "consumingApplicationId")
    @Mapping(source = "producingApplicationId", target = "producingApplicationId")
    @Mapping(source = "granularity", target = "granularity")
    @Mapping(source = "performanceIndicatorGroupSpecification", target = "performanceIndicatorGroupSpecification")
    @Mapping(source = "performanceIndicatorSpecification", target = "performanceIndicatorSpecification")
    @Mapping(source = "trackingRecord", target = "trackingRecord")
    MeasurementJob toMeasurementJob(MeasurementJobMVO measurementJobMVO);

    @Mapping(source = "consumingApplicationId", target = "consumingApplicationId")
    @Mapping(source = "producingApplicationId", target = "producingApplicationId")
    @Mapping(source = "granularity", target = "granularity")
    @Mapping(source = "performanceIndicatorGroupSpecification", target = "performanceIndicatorGroupSpecification")
    @Mapping(source = "performanceIndicatorSpecification", target = "performanceIndicatorSpecification")
    @Mapping(source = "trackingRecord", target = "trackingRecord")
    MeasurementJobMVO toMeasurementJobMVO(MeasurementJob measurementJob);
}