package org.etsi.osl.metrico.mapper;

import org.etsi.osl.tmf.pm628.model.Characteristic;
import org.etsi.osl.tmf.pm628.model.CharacteristicMVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

@Mapper(uses = {CharacteristicRelationshipMapper.class})
public interface CharacteristicMapper {
    CharacteristicMapper INSTANCE = Mappers.getMapper(CharacteristicMapper.class);

    @Mapping(source = "type", target = "type")
    @Mapping(source = "baseType", target = "baseType")
    @Mapping(source = "schemaLocation", target = "schemaLocation")
    @Mapping(source = "uuid", target = "uuid")
    @Mapping(source = "name", target = "name")
    @Mapping(source = "valueType", target = "valueType")
    @Mapping(source = "characteristicRelationship", target = "characteristicRelationship")
    Characteristic toCharacteristic(CharacteristicMVO characteristicMVO);

    @Mapping(source = "type", target = "type")
    @Mapping(source = "baseType", target = "baseType")
    @Mapping(source = "schemaLocation", target = "schemaLocation")
    @Mapping(source = "uuid", target = "uuid")
    @Mapping(source = "name", target = "name")
    @Mapping(source = "valueType", target = "valueType")
    @Mapping(source = "characteristicRelationship", target = "characteristicRelationship")
    CharacteristicMVO toCharacteristicMVO(Characteristic characteristic);
}