#!/bin/sh

dirlocation=`pwd`/.
# If no argument is provided, use "main" as the default value
default_branch="main"
branch="${1:-$default_branch}"

echo "Selected branch: $branch"
echo "We're working with $dirlocation"
cd $dirlocation


updaterepo(){
        cd $dirlocation
        echo "Build " $1
        if [ ! -d $1 ]; then
                git clone https://labs.etsi.org/rep/osl/code/$1.git
        fi

        cd $1/
        git checkout $branch
        git pull

        # Build maven project if .pom file is present
        if [ -f  "./pom.xml" ]; then
            docker run -it --rm -v "/home/ubuntu/.m2":/root/.m2 -v "$(pwd)":/opt/maven -w /opt/maven maven:3.9.9-ibm-semeru-17-focal mvn clean verify -DskipTests
        fi
}


updaterepo org.etsi.osl.main
#updaterepo org.etsi.osl.sol005nbi.osm
#updaterepo org.etsi.osl.sol005nbi.osm10
#updaterepo org.etsi.osl.centrallog.client
updaterepo org.etsi.osl.centrallog.service
#updaterepo org.etsi.osl.model.nfv
#updaterepo org.etsi.osl.model.tmf
#updaterepo org.etsi.osl.model.k8s
updaterepo org.etsi.osl.portal.api
updaterepo org.etsi.osl.mano
updaterepo org.etsi.osl.bugzilla
updaterepo org.etsi.osl.osom
updaterepo org.etsi.osl.oas
updaterepo org.etsi.osl.tmf.api
updaterepo org.etsi.osl.cridge
updaterepo org.etsi.osl.metrico
updaterepo org.etsi.osl.mcp.server

updaterepo org.etsi.osl.tmf.web
updaterepo org.etsi.osl.portal.web


echo "Build org.etsi.osl.tmf.web" 

cd $dirlocation/org.etsi.osl.tmf.web

if [ ! -f  "./src/assets/config/theming.scss" ]; then
    cp ./src/assets/config/theming.default.scss ./src/assets/config/theming.scss
fi
if [ ! -f  "./src/assets/config/config.prod.json" ]; then
    cp ./src/assets/config/config.prod.default.json ./src/assets/config/config.prod.json
fi

echo "Installing npm packages..."

docker run -u $(id -u) --rm -v "$PWD":/app trion/ng-cli:14.2.9 npm install
docker run -u $(id -u) --rm -v "$PWD":/app trion/ng-cli:14.2.9 ng build --configuration production
