#!/bin/sh

dirlocation=`pwd`/.
echo "We're working with $dirlocation"
cd $dirlocation
tagname=latest

buildimg(){
        cd $dirlocation/$1
        echo "Build " $1
        sudo docker build -t openslice/$1:$tagname -f $2 .
        sudo docker push  openslice/$1:$tagname
}

buildimg org.etsi.osl.centrallog.service Dockerfile.centrallog
buildimg org.etsi.osl.portal.api Dockerfile.portalapi
buildimg org.etsi.osl.mano Dockerfile.mano
buildimg org.etsi.osl.bugzilla Dockerfile.bugzilla
buildimg org.etsi.osl.osom Dockerfile.osom
buildimg org.etsi.osl.portal.web Dockerfile
buildimg org.etsi.osl.tmf.api Dockerfile.tmfapi
buildimg org.etsi.osl.oas Dockerfile.oasapi



cd $dirlocation/org.etsi.osl.tmf.web
docker run -u 0 --rm -v "$PWD":/app trion/ng-cli npm install
docker run -u 0 --rm -v "$PWD":/app trion/ng-cli ng build --prod --deleteOutputPath=false
buildimg org.etsi.osl.tmf.web Dockerfile