/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.cridge;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import jakarta.annotation.PreDestroy;
import org.etsi.osl.cridge.CatalogClient;
import org.etsi.osl.cridge.KubernetesClientResource;
import org.etsi.osl.tmf.ri639.model.Resource;
import org.etsi.osl.tmf.ri639.model.ResourceCreate;
import org.etsi.osl.tmf.ri639.model.ResourceUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class WatcherService {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.etsi.osl.cridge");
    private Watch watch;
    @Autowired
    CatalogClient catalogClient;
    @Autowired
    private KubernetesClientResource kubernetesClientResource;

    @EventListener(value={ApplicationStartedEvent.class})
    public void onApplicationEvent() {
        logger.info("Starting WatcherService for cluster getContexts {} ", (Object)this.kubernetesClientResource.getKubernetesClient().getConfiguration().getContexts().toString());
        Resource result = this.registerKubernetesClientInOSLResource();
        while (result == null) {
            try {
                logger.info("Cannot get resource for registerKubernetesClient. Retrying in 10 seconds");
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            result = this.registerKubernetesClientInOSLResource();
        }
        SharedInformerFactory sharedInformerFactory = this.kubernetesClientResource.getKubernetesClient().informers();
        SharedIndexInformer shixInformer = sharedInformerFactory.sharedIndexInformerFor(CustomResourceDefinition.class, 30000L);
        shixInformer.addEventHandler((ResourceEventHandler)new /* Unavailable Anonymous Inner Class!! */);
        sharedInformerFactory.startAllRegisteredInformers();
    }

    private Resource registerKubernetesClientInOSLResource() {
        try {
            ResourceCreate rsc = this.kubernetesClientResource.getKubernetesContextDefinition().toResourceCreate();
            Resource result = this.catalogClient.createOrUpdateResourceByNameCategoryVersion(rsc);
            return result;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    protected void createCRDSharedIndexInformer(CustomResourceDefinition crd) {
        ResourceDefinitionContext context = new ResourceDefinitionContext.Builder().withGroup(crd.getSpec().getGroup()).withVersion(((CustomResourceDefinitionVersion)crd.getSpec().getVersions().get(0)).getName()).withKind(crd.getSpec().getNames().getKind()).withPlural(crd.getSpec().getNames().getPlural()).build();
        try {
            int n = ((GenericKubernetesResourceList)this.kubernetesClientResource.getKubernetesClient().genericKubernetesResources(context).list()).getItems().size();
        }
        catch (Exception e) {
            logger.error("Cannot create createCRDSharedIndexInformer. Seems there are no resources for kind: " + crd.getSpec().getNames().getKind());
            return;
        }
        logger.debug("Creating new Watcher for kind: {}", (Object)crd.getSpec().getNames().getKind());
        Watch watch = ((AnyNamespaceOperation)this.kubernetesClientResource.getKubernetesClient().genericKubernetesResources(context).inAnyNamespace()).watch((Watcher)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void updateGenericKubernetesResourceInOSLCatalog(GenericKubernetesResource genericKubernetesResource) {
        String oslResourceId = (String)genericKubernetesResource.getMetadata().getLabels().get("org.etsi.osl.resourceId");
        if (oslResourceId != null) {
            ResourceUpdate rs = this.kubernetesClientResource.KubernetesCR2OpensliceCR(genericKubernetesResource).toResourceUpdate();
            this.catalogClient.updateResourceById(oslResourceId, rs);
        } else {
            ResourceCreate rs = this.kubernetesClientResource.KubernetesCR2OpensliceCR(genericKubernetesResource).toResourceCreate();
            this.catalogClient.createOrUpdateResourceByNameCategoryVersion(rs);
        }
    }

    @PreDestroy
    ApplicationListener<ContextStoppedEvent> stop() {
        logger.info("Closing due to ContextStoppedEvent ");
        return event -> this.watch.close();
    }
}

