/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.cridge;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NamespaceableResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.etsi.osl.cridge.CatalogClient;
import org.etsi.osl.cridge.NamespaceWatcher;
import org.etsi.osl.domain.model.kubernetes.KubernetesCRDProperty;
import org.etsi.osl.domain.model.kubernetes.KubernetesCRDV1;
import org.etsi.osl.domain.model.kubernetes.KubernetesCRV1;
import org.etsi.osl.domain.model.kubernetes.KubernetesContextDefinition;
import org.etsi.osl.tmf.common.model.EValueType;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecification;
import org.etsi.osl.tmf.ri639.model.ResourceStatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesClientResource {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.etsi.osl.cridge");
    @Autowired
    private KubernetesClient kubernetesClient;
    @Autowired
    CatalogClient catalogClient;
    private KubernetesContextDefinition kubernetesContextDefinition = null;
    private ResourceSpecification kubernetesCRDV1ResourceSpec = null;
    private ResourceSpecification kubernetesCRV1ResourceSpec = null;
    private ConcurrentHashMap<String, Date> nameSpacesTobeDeleted = new ConcurrentHashMap();
    private Map<String, NamespaceWatcher> watchersForNamespaces = new HashMap();

    public KubernetesContextDefinition getKubernetesContextDefinition() throws Exception {
        if (this.kubernetesContextDefinition == null) {
            ResourceSpecification rspec = this.catalogClient.retrieveResourceSpecByNameCategoryVersion("kubernetes-context-definition.openslice.io", "KubernetesContextDefinition", "0.0.1");
            if (rspec == null) {
                throw new Exception("Cannot retrieve KubernetesContextDefinition ResourceSpecification");
            }
            this.kubernetesContextDefinition = KubernetesContextDefinition.builder().osl_KUBD_SPEC_UUID(rspec.getUuid()).name(this.getKubernetesClient().getConfiguration().getCurrentContext().getContext().getCluster() + "@" + this.kubernetesClient.getMasterUrl().toExternalForm()).clusterVersion(this.kubernetesClient.getKubernetesVersion().getMajor() + "." + this.kubernetesClient.getKubernetesVersion().getMinor()).masterURL(this.kubernetesClient.getMasterUrl().toExternalForm()).currentContextCluster(this.kubernetesClient.getConfiguration().getCurrentContext().getContext().getCluster()).currentContextName(this.kubernetesClient.getConfiguration().getCurrentContext().getName()).currentContextUser(this.kubernetesClient.getConfiguration().getCurrentContext().getContext().getUser()).build();
            this.kubernetesCRDV1ResourceSpec = this.catalogClient.retrieveResourceSpecByNameCategoryVersion("kubernetes-crd.openslice.io", "KubernetesCRD-apiextensions.k8s.io/v1", "0.0.3");
            this.kubernetesCRV1ResourceSpec = this.catalogClient.retrieveResourceSpecByNameCategoryVersion("kubernetes-cr-v1.openslice.io", "KubernetesCRV1-apiextensions.k8s.io/v1", "0.0.4");
        }
        return this.kubernetesContextDefinition;
    }

    List<KubernetesCRDV1> KubernetesCRD2OpensliceCRD(CustomResourceDefinition crd) {
        ArrayList<KubernetesCRDV1> result = new ArrayList<KubernetesCRDV1>();
        crd.getSpec().getVersions().stream().forEach(version -> {
            KubernetesCRDV1 kcrd = KubernetesCRDV1.builder().osl_KUBCRD_RSPEC_UUID(this.kubernetesCRDV1ResourceSpec.getUuid()).name(crd.getSpec().getNames().getKind() + "@" + crd.getSpec().getGroup() + "/" + version.getName() + "@" + this.kubernetesClient.getConfiguration().getCurrentContext().getContext().getCluster() + "@" + this.kubernetesClient.getMasterUrl().toExternalForm()).version(version.getName()).currentContextCluster(this.kubernetesClient.getConfiguration().getCurrentContext().getContext().getCluster()).clusterMasterURL(this.kubernetesClient.getMasterUrl().toString()).fullResourceName(crd.getFullResourceName()).kind(crd.getSpec().getNames().getKind()).apiGroup(crd.getSpec().getGroup()).uID(crd.getMetadata().getUid()).description(version.getSchema().getOpenAPIV3Schema().getDescription()).metadata("").build();
            if (version.getSchema().getOpenAPIV3Schema().getProperties() != null) {
                version.getSchema().getOpenAPIV3Schema().getProperties().forEach((kPropName, vProVal) -> {
                    if (kPropName.equals("spec") || kPropName.equals("status")) {
                        logger.debug("propName={} propValue={} ", kPropName, (Object)vProVal.getType());
                        this.addCRDProperties(kcrd, kPropName, vProVal, "");
                    }
                });
            }
            if (version.getSchema().getOpenAPIV3Schema().getAdditionalProperties() != null) {
                version.getSchema().getOpenAPIV3Schema().getAdditionalProperties().getAdditionalProperties().forEach((kPropName, vProVal) -> {
                    logger.debug("propName={} propValue={} ", kPropName, vProVal);
                    KubernetesCRDProperty kpcrdProperty = KubernetesCRDProperty.builder().name(kPropName).build();
                    kcrd.getAdditionalProperties().put("additionalProperty." + kPropName, kpcrdProperty);
                });
            }
            kcrd.setYaml(Serialization.asYaml((Object)version.getSchema().getOpenAPIV3Schema().getProperties()));
            kcrd.setJson(Serialization.asJson((Object)version.getSchema().getOpenAPIV3Schema().getProperties()));
            result.add(kcrd);
        });
        return result;
    }

    private void addCRDProperties(KubernetesCRDV1 kcrd, String kPropName, JSONSchemaProps vProVal, String prefix) {
        EValueType etype;
        String propertyToAdd = prefix + kPropName;
        if (vProVal.getType() == null) {
            etype = EValueType.TEXT;
        } else if (vProVal.getType().equalsIgnoreCase("boolean")) {
            etype = EValueType.BOOLEAN;
        } else if (vProVal.getType().equalsIgnoreCase("integer")) {
            etype = EValueType.INTEGER;
        } else if (vProVal.getType().equalsIgnoreCase("object")) {
            etype = EValueType.OBJECT;
            vProVal.getProperties().forEach((pk, pv) -> this.addCRDProperties(kcrd, pk, pv, propertyToAdd + "."));
        } else if (vProVal.getType().equalsIgnoreCase("array")) {
            etype = EValueType.ARRAY;
            vProVal.getProperties().forEach((pk, pv) -> this.addCRDProperties(kcrd, pk, pv, propertyToAdd + "[]."));
        } else {
            etype = EValueType.TEXT;
        }
        KubernetesCRDProperty kpcrdProperty = KubernetesCRDProperty.builder().name(kPropName).description(vProVal.getDescription()).defaultValue(vProVal.getDefault() != null ? vProVal.getDefault().asText() : "").valueType(etype.getValue()).build();
        kcrd.getProperties().put(propertyToAdd, kpcrdProperty);
    }

    KubernetesCRV1 KubernetesCR2OpensliceCR(GenericKubernetesResource gkr) {
        String baseCRD = String.format("%s@%s@%s@%s", gkr.getKind(), gkr.getApiVersion(), this.kubernetesClient.getConfiguration().getCurrentContext().getContext().getCluster(), this.kubernetesClient.getMasterUrl().toExternalForm());
        KubernetesCRV1 kcrv = KubernetesCRV1.builder().osl_KUBCRV1_RSPEC_UUID(this.kubernetesCRV1ResourceSpec.getUuid()).name(gkr.getMetadata().getName() + "@" + gkr.getMetadata().getNamespace() + "@" + this.kubernetesClient.getConfiguration().getCurrentContext().getContext().getCluster() + "@" + this.kubernetesClient.getMasterUrl().toExternalForm()).version(gkr.getApiVersion()).currentContextCluster(this.kubernetesClient.getConfiguration().getCurrentContext().getContext().getCluster()).clusterMasterURL(this.kubernetesClient.getMasterUrl().toString()).fullResourceName("").namespace(Serialization.asJson((Object)gkr.getMetadata().getNamespace())).kind(gkr.getKind()).apiGroup(gkr.getPlural()).uID(gkr.getMetadata().getUid()).metadata(gkr.getMetadata().toString()).category(baseCRD).description(String.format("A CR in namespace %s based on CRD %s", gkr.getMetadata().getNamespace(), baseCRD)).build();
        gkr.getMetadata().getLabels().forEach((pk, pv) -> {
            logger.debug("\t label: {} {} ", pk, pv);
            kcrv.getProperties().put(pk, pv);
        });
        kcrv.setStatusCheckFieldName((String)gkr.getMetadata().getLabels().get("org.etsi.osl.statusCheckFieldName"));
        kcrv.setStatusCheckValueStandby((String)gkr.getMetadata().getLabels().get("org.etsi.osl.statusCheckValueStandby"));
        kcrv.setStatusCheckValueAlarm((String)gkr.getMetadata().getLabels().get("org.etsi.osl.statusCheckValueAlarm"));
        kcrv.setStatusCheckValueAvailable((String)gkr.getMetadata().getLabels().get("org.etsi.osl.statusCheckValueAvailable"));
        kcrv.setStatusCheckValueReserved((String)gkr.getMetadata().getLabels().get("org.etsi.osl.statusCheckValueReserved"));
        kcrv.setStatusCheckValueUnknown((String)gkr.getMetadata().getLabels().get("org.etsi.osl.statusCheckValueUnknown"));
        kcrv.setStatusCheckValueSuspended((String)gkr.getMetadata().getLabels().get("org.etsi.osl.statusCheckValueSuspended"));
        kcrv.setStatusValue(ResourceStatusType.UNKNOWN);
        gkr.getAdditionalProperties().forEach((pk, pv) -> {
            logger.debug("\t {} {} ", pk, pv);
            if (pv instanceof Map) {
                this.addCRVProperties(kcrv, pk, (Map)pv, "");
            } else {
                Map values = (Map)pv;
                values.forEach((speck, specv) -> {
                    logger.debug("\t  {}={} ", speck, specv);
                    String propertyName = pk + "." + speck;
                    String propertyValue = specv.toString();
                    kcrv.getProperties().put(propertyName, propertyValue);
                    if (kcrv.getStatusCheckFieldName().equals(propertyName)) {
                        kcrv.setStatusValue(this.checKCRVResourceStatus(kcrv, propertyValue));
                    }
                });
            }
        });
        kcrv.getProperties().put("AdditionPropertiesAsJson", Serialization.asJson((Object)gkr.getAdditionalProperties()));
        kcrv.setYaml(Serialization.asYaml((Object)gkr));
        kcrv.setJson(Serialization.asJson((Object)gkr));
        kcrv.setCr_spec_applied(Serialization.asJson((Object)gkr));
        return kcrv;
    }

    private ResourceStatusType checKCRVResourceStatus(KubernetesCRV1 kcrv, String propertyValue) {
        if (propertyValue.equals(kcrv.getStatusCheckValueAlarm())) {
            return ResourceStatusType.ALARM;
        }
        if (propertyValue.equals(kcrv.getStatusCheckValueAvailable())) {
            return ResourceStatusType.AVAILABLE;
        }
        if (propertyValue.equals(kcrv.getStatusCheckValueReserved())) {
            return ResourceStatusType.RESERVED;
        }
        if (propertyValue.equals(kcrv.getStatusCheckValueStandby())) {
            return ResourceStatusType.STANDBY;
        }
        if (propertyValue.equals(kcrv.getStatusCheckValueSuspended())) {
            return ResourceStatusType.SUSPENDED;
        }
        if (propertyValue.equals(kcrv.getStatusCheckValueUnknown())) {
            return ResourceStatusType.UNKNOWN;
        }
        return ResourceStatusType.UNKNOWN;
    }

    private void addCRVProperties(KubernetesCRV1 kcrv, String kPropName, Map<String, Object> vProVal, String prefix) {
        vProVal.forEach((speck, specv) -> {
            if (specv instanceof Map) {
                String propertyToAdd = prefix + kPropName;
                this.addCRVProperties(kcrv, speck, (Map)specv, propertyToAdd + ".");
            } else {
                String propertyToAdd = prefix + kPropName + "." + speck;
                logger.debug("\t {} {}={} ", new Object[]{propertyToAdd, speck, specv});
                kcrv.getProperties().put(propertyToAdd, specv.toString());
                String propertyName = propertyToAdd;
                String propertyValue = specv.toString();
                if (kcrv.getStatusCheckFieldName() != null && kcrv.getStatusCheckFieldName().equals(propertyName)) {
                    kcrv.setStatusValue(this.checKCRVResourceStatus(kcrv, propertyValue));
                }
            }
        });
    }

    public String deployCR(Map<String, Object> headers, String crspec) {
        logger.debug("============ Deploy crspec =============");
        logger.debug("Check if this CRIDGE instance is related to this kubernets cluster context");
        if (!this.checkCRIDGEClusterContext(headers).booleanValue()) {
            return "SEE OTHER";
        }
        logger.debug("Deploy the following CR:");
        logger.debug("{}", (Object)crspec);
        try {
            GenericKubernetesResource gkr = (GenericKubernetesResource)Serialization.unmarshal((String)crspec);
            headers.forEach((hname, hval) -> {
                if (hval instanceof String) {
                    String s = (String)hval;
                    if (hname.contains("org.etsi.osl")) {
                        logger.debug("Header: {} = {} ", hname, (Object)s);
                        if (gkr.getMetadata() == null) {
                            gkr.setMetadata(new ObjectMeta());
                            gkr.getMetadata().setLabels(new HashMap());
                        }
                        gkr.getMetadata().getLabels().put(hname, s);
                    }
                }
            });
            if (headers.get("org.etsi.osl.prefixId") != null) {
                gkr.getMetadata().setName((String)headers.get("org.etsi.osl.prefixName"));
            } else {
                gkr.getMetadata().setName("cr" + ((String)headers.get("org.etsi.osl.resourceId")).substring(0, 8));
            }
            if (gkr.getMetadata().getNamespace() == null || gkr.getMetadata().getNamespace().equals("")) {
                gkr.getMetadata().setNamespace((String)headers.get("org.etsi.osl.serviceOrderId"));
            }
            String nameSpacename = (String)headers.get("org.etsi.osl.namespace");
            try {
                Namespace ns = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(nameSpacename)).addToLabels("org.etsi.osl", "org.etsi.osl")).endMetadata()).build();
                ((Resource)this.kubernetesClient.namespaces().resource((Object)ns)).create();
            }
            catch (Exception e) {
                logger.info("Cannot create namespace, already exists!" + e.getMessage());
            }
            if (this.watchersForNamespaces.get(nameSpacename) == null) {
                NamespaceWatcher result = NamespaceWatcher.getNew((KubernetesClient)this.kubernetesClient, (CatalogClient)this.catalogClient, (String)nameSpacename, headers);
                this.watchersForNamespaces.put(nameSpacename, result);
            }
            logger.debug("Object to deploy:{}", (Object)gkr.toString());
            NamespaceableResource dummyObject = this.kubernetesClient.resource((HasMetadata)gkr);
            GenericKubernetesResource result = (GenericKubernetesResource)dummyObject.create();
            logger.debug("============ Create crspec: result {} =============", (Object)result.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "FAIL " + e.getMessage();
        }
        return "OK";
    }

    public String deleteCR(Map<String, Object> headers, String crspec) {
        logger.debug("============ DELETE crspec =============");
        if (!this.checkCRIDGEClusterContext(headers).booleanValue()) {
            return "SEE OTHER";
        }
        try {
            GenericKubernetesResource gkr = (GenericKubernetesResource)Serialization.unmarshal((String)crspec);
            headers.forEach((hname, hval) -> {
                if (hval instanceof String) {
                    String s = (String)hval;
                    if (hname.contains("org.etsi.osl")) {
                        logger.debug("Header: {} = {} ", hname, (Object)s);
                        gkr.getMetadata().getLabels().put(hname, s);
                    }
                }
            });
            gkr.getMetadata().setName((String)headers.get("org.etsi.osl.prefixName"));
            String nameSpacename = (String)headers.get("org.etsi.osl.namespace");
            if (gkr.getMetadata().getNamespace() == null) {
                gkr.getMetadata().setNamespace(nameSpacename);
            }
            logger.debug("Object to delete:{}", (Object)Serialization.asYaml((Object)gkr));
            NamespaceableResource dummyObject = this.kubernetesClient.resource((HasMetadata)gkr);
            List result = dummyObject.delete();
            logger.debug("============ DELETE crspec: result {} =============", (Object)result.toString());
            this.nameSpacesTobeDeleted.put(nameSpacename, new Date());
            NamespaceWatcher watchersForNamespace = (NamespaceWatcher)this.watchersForNamespaces.get(nameSpacename);
            if (watchersForNamespace != null) {
                watchersForNamespace.disableNamespace(nameSpacename);
            }
            this.watchersForNamespaces.remove(nameSpacename);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "ERROR " + e.getMessage();
        }
        return "OK";
    }

    public String patchCR(Map<String, Object> headers, String crspec) {
        logger.debug("============ patchCR crspec =============");
        logger.debug("Check if this CRIDGE instance is related to this kubernets cluster context");
        if (!this.checkCRIDGEClusterContext(headers).booleanValue()) {
            return "SEE OTHER";
        }
        logger.debug("Patch the following CR:");
        logger.debug("{}", (Object)crspec);
        try {
            GenericKubernetesResource gkr = (GenericKubernetesResource)Serialization.unmarshal((String)crspec);
            headers.forEach((hname, hval) -> {
                if (hval instanceof String) {
                    String s = (String)hval;
                    if (hname.contains("org.etsi.osl")) {
                        logger.debug("Header: {} = {} ", hname, (Object)s);
                        if (gkr.getMetadata() == null) {
                            gkr.setMetadata(new ObjectMeta());
                            gkr.getMetadata().setLabels(new HashMap());
                        }
                        gkr.getMetadata().getLabels().put(hname, s);
                    }
                }
            });
            if (headers.get("org.etsi.osl.prefixId") != null) {
                gkr.getMetadata().setName((String)headers.get("org.etsi.osl.prefixName"));
            } else {
                gkr.getMetadata().setName("cr" + ((String)headers.get("org.etsi.osl.resourceId")).substring(0, 8));
            }
            if (gkr.getMetadata().getNamespace() == null || gkr.getMetadata().getNamespace().equals("")) {
                gkr.getMetadata().setNamespace((String)headers.get("org.etsi.osl.serviceOrderId"));
            }
            logger.debug("{}", (Object)gkr.toString());
            NamespaceableResource dummyObject = this.kubernetesClient.resource((HasMetadata)gkr);
            dummyObject.patch();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "FAIL " + e.getMessage();
        }
        return "OK";
    }

    private Boolean checkCRIDGEClusterContext(Map<String, Object> headers) {
        if (headers.get("currentContextCluster") == null || headers.get("clusterMasterURL") == null || !headers.get("currentContextCluster").equals(this.kubernetesContextDefinition.getCurrentContextCluster()) || !headers.get("clusterMasterURL").equals(this.kubernetesContextDefinition.getMasterURL())) {
            logger.debug("Will return SEE OTHER header.currentContextCluster={}, this.context= {} header.clusterMasterURLclusterMasterURL={}, this.context= {}", new Object[]{headers.get("currentContextCluster"), this.kubernetesContextDefinition.getCurrentContextCluster(), headers.get("clusterMasterURL"), this.kubernetesContextDefinition.getMasterURL()});
            return false;
        }
        return true;
    }

    public void setKubernetesClient(KubernetesClient kubernetesClient2) {
        this.kubernetesClient = kubernetesClient2;
    }

    public KubernetesClient getKubernetesClient() {
        return this.kubernetesClient;
    }

    public CatalogClient getCatalogClient() {
        return this.catalogClient;
    }

    public ResourceSpecification getKubernetesCRDV1ResourceSpec() {
        return this.kubernetesCRDV1ResourceSpec;
    }

    public ResourceSpecification getKubernetesCRV1ResourceSpec() {
        return this.kubernetesCRV1ResourceSpec;
    }

    public ConcurrentHashMap<String, Date> getNameSpacesTobeDeleted() {
        return this.nameSpacesTobeDeleted;
    }

    public Map<String, NamespaceWatcher> getWatchersForNamespaces() {
        return this.watchersForNamespaces;
    }
}

