/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.cridge;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.etsi.osl.tmf.rcm634.model.LogicalResourceSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationCreate;
import org.etsi.osl.tmf.ri639.model.LogicalResource;
import org.etsi.osl.tmf.ri639.model.Resource;
import org.etsi.osl.tmf.ri639.model.ResourceCreate;
import org.etsi.osl.tmf.ri639.model.ResourceUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CatalogClient
extends RouteBuilder {
    private static final Logger logger = LoggerFactory.getLogger((String)CatalogClient.class.getSimpleName());
    @Autowired
    private ProducerTemplate template;
    @Value(value="${CATALOG_GET_RESOURCESPEC_BY_ID}")
    private String CATALOG_GET_RESOURCESPEC_BY_ID = "";
    @Value(value="${CATALOG_GET_RESOURCESPEC_BY_NAME_CATEGORY}")
    private String CATALOG_GET_RESOURCESPEC_BY_NAME_CATEGORY = "";
    @Value(value="${CATALOG_UPDADD_RESOURCESPEC}")
    private String CATALOG_UPDADD_RESOURCESPEC = "";
    @Value(value="${CATALOG_UPDADD_RESOURCE}")
    private String CATALOG_UPDADD_RESOURCE = "";
    @Value(value="${CATALOG_UPD_RESOURCE}")
    private String CATALOG_UPD_RESOURCE = "";
    @Value(value="${CATALOG_GET_RESOURCE_BY_ID}")
    private String CATALOG_GET_RESOURCE_BY_ID = "";

    public void configure() throws Exception {
    }

    public ResourceSpecification retrieveResourceSpecByNameCategoryVersion(String aName, String aCategory, String aVersion) {
        logger.info("will retrieve Resource Specification aName=" + aName);
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("aname", aName);
            map.put("acategory", aCategory);
            map.put("aversion", aVersion);
            Object response = this.template.requestBodyAndHeaders(this.CATALOG_GET_RESOURCESPEC_BY_NAME_CATEGORY, null, map);
            if (!(response instanceof String)) {
                logger.error("Resource Specification object is wrong.");
                return null;
            }
            LogicalResourceSpecification sor = (LogicalResourceSpecification)this.toJsonObj((String)response, LogicalResourceSpecification.class);
            return sor;
        }
        catch (Exception e) {
            logger.error("Cannot retrieve Resource Specification details from catalog. " + e.toString());
            return null;
        }
    }

    public ResourceSpecification retrieveResourceSpec(String specid) {
        logger.info("will retrieve Resource Specification id=" + specid);
        try {
            Object response = this.template.requestBody(this.CATALOG_GET_RESOURCESPEC_BY_ID, (Object)specid);
            if (!(response instanceof String)) {
                logger.error("Resource Specification object is wrong.");
                return null;
            }
            LogicalResourceSpecification sor = (LogicalResourceSpecification)this.toJsonObj((String)response, LogicalResourceSpecification.class);
            return sor;
        }
        catch (Exception e) {
            logger.error("Cannot retrieve Resource Specification details from catalog. " + e.toString());
            return null;
        }
    }

    public LogicalResourceSpecification createOrUpdateResourceSpecByNameCategoryVersion(ResourceSpecificationCreate s) {
        logger.info("will createOrUpdateResourceSpecByNameCategoryVersion ");
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("aname", s.getName());
            map.put("aversion", s.getVersion());
            map.put("acategory", s.getCategory());
            Object response = this.template.requestBodyAndHeaders(this.CATALOG_UPDADD_RESOURCESPEC, (Object)this.toJsonString((Object)s), map);
            if (!(response instanceof String)) {
                logger.error("ResourceSpecification  object is wrong.");
            }
            LogicalResourceSpecification rs = (LogicalResourceSpecification)this.toJsonObj((String)response, LogicalResourceSpecification.class);
            return rs;
        }
        catch (Exception e) {
            logger.error("Cannot create ResourceSpecification");
            e.printStackTrace();
            return null;
        }
    }

    public Resource createOrUpdateResourceByNameCategoryVersion(ResourceCreate s) {
        logger.info("will createOrUpdateResourceByNameVersion a Resource ");
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("aname", s.getName());
            map.put("aversion", s.getResourceVersion());
            map.put("acategory", s.getCategory());
            Object response = this.template.requestBodyAndHeaders(this.CATALOG_UPDADD_RESOURCE, (Object)this.toJsonString((Object)s), map);
            if (!(response instanceof String)) {
                logger.error("Resource  object is wrong.");
            }
            logger.debug(response.toString());
            try {
                LogicalResource rs = (LogicalResource)this.toJsonObj((String)response, LogicalResource.class);
                return rs;
            }
            catch (Exception e) {
                logger.error("Cannot create LogicalResource");
                e.printStackTrace();
                try {
                    Resource rs = (Resource)this.toJsonObj((String)response, Resource.class);
                    return rs;
                }
                catch (Exception e2) {
                    logger.error("Cannot create as Resource");
                    e2.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            logger.error("Cannot create Resource");
            e.printStackTrace();
        }
        return null;
    }

    private <T> T toJsonObj(String content, Class<T> valueType) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return (T)mapper.readValue(content, valueType);
    }

    private String toJsonString(Object object) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper.writeValueAsString(object);
    }

    public Resource updateResourceById(String oslResourceId, ResourceUpdate rs) {
        logger.info("will update Resource : " + oslResourceId);
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("resourceId", oslResourceId);
            map.put("triggerServiceActionQueue", false);
            Object response = this.template.requestBodyAndHeaders(this.CATALOG_UPD_RESOURCE, (Object)this.toJsonString((Object)rs), map);
            if (!(response instanceof String)) {
                logger.error("Service Instance object is wrong.");
            }
            LogicalResource resourceInstance = (LogicalResource)this.toJsonObj((String)response, LogicalResource.class);
            return resourceInstance;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Cannot update Service: " + oslResourceId + ": " + e.toString());
            return null;
        }
    }
}

