/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.cridge;

import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.etsi.osl.cridge.KubernetesClientResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CRRouteBuilder
extends RouteBuilder {
    @Value(value="${CRD_DEPLOY_CR_REQ}")
    private String CRD_DEPLOY_CR_REQ = "";
    @Value(value="${CRD_PATCH_CR_REQ}")
    private String CRD_PATCH_CR_REQ = "";
    @Value(value="${CRD_DELETE_CR_REQ}")
    private String CRD_DELETE_CR_REQ = "";
    @Autowired
    private KubernetesClientResource kubernetesClientResource;
    private static final Logger logger = LoggerFactory.getLogger((String)CRRouteBuilder.class.getSimpleName());

    public void configure() throws Exception {
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(this.CRD_DEPLOY_CR_REQ).log(LoggingLevel.INFO, this.log, this.CRD_DEPLOY_CR_REQ + " message received!")).to("log:DEBUG?showBody=true&showHeaders=true")).bean((Object)this.kubernetesClientResource, "deployCR(${headers}, ${body})")).convertBodyTo(String.class);
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(this.CRD_DELETE_CR_REQ).log(LoggingLevel.INFO, this.log, this.CRD_DELETE_CR_REQ + " message received!")).to("log:DEBUG?showBody=true&showHeaders=true")).bean((Object)this.kubernetesClientResource, "deleteCR(${headers}, ${body})")).convertBodyTo(String.class);
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(this.CRD_PATCH_CR_REQ).log(LoggingLevel.INFO, this.log, this.CRD_PATCH_CR_REQ + " message received!")).to("log:DEBUG?showBody=true&showHeaders=true")).bean((Object)this.kubernetesClientResource, "patchCR(${headers}, ${body})")).convertBodyTo(String.class);
        ((RouteDefinition)((RouteDefinition)this.from("timer://processUpdateResources?period=120000").log(LoggingLevel.INFO, this.log, " process nameSpacesTobeDeleted!")).to("log:DEBUG?showBody=true&showHeaders=true")).bean(CRRouteBuilder.class, "processNameSpacesTobeDeleted()");
    }

    public void processNameSpacesTobeDeleted() {
        this.kubernetesClientResource.getNameSpacesTobeDeleted().forEach((nameSpaceName, datetime) -> {
            Date currentTime = new Date();
            long diffInMillies = Math.abs(currentTime.getTime() - datetime.getTime());
            long diff = TimeUnit.MINUTES.convert(diffInMillies, TimeUnit.MILLISECONDS);
            if (diff <= 2L) {
                return;
            }
            try (KubernetesClient k8s = new KubernetesClientBuilder().build();){
                logger.info("Trying to delete namespace {}", nameSpaceName);
                Namespace ns = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(nameSpaceName)).endMetadata()).build();
                ((Resource)k8s.namespaces().resource((Object)ns)).delete();
                this.kubernetesClientResource.getNameSpacesTobeDeleted().remove(nameSpaceName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public String getCRD_DEPLOY_CR_REQ() {
        return this.CRD_DEPLOY_CR_REQ;
    }

    public String getCRD_PATCH_CR_REQ() {
        return this.CRD_PATCH_CR_REQ;
    }

    public String getCRD_DELETE_CR_REQ() {
        return this.CRD_DELETE_CR_REQ;
    }

    public KubernetesClientResource getKubernetesClientResource() {
        return this.kubernetesClientResource;
    }
}

