/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.cridge;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.etsi.osl.cridge.CatalogClient;
import org.etsi.osl.cridge.KubernetesClientResource;
import org.etsi.osl.domain.model.kubernetes.KubernetesCRDV1;
import org.etsi.osl.tmf.ri639.model.Resource;
import org.etsi.osl.tmf.ri639.model.ResourceCreate;
import org.etsi.osl.tmf.ri639.model.ResourceUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class WatcherService {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.etsi.osl.cridge");
    private Watch watch;
    @Autowired
    CatalogClient catalogClient;
    @Autowired
    private KubernetesClientResource kubernetesClientResource;

    @EventListener(value={ApplicationStartedEvent.class})
    public void onApplicationEvent() {
        logger.info("Starting WatcherService for cluster getContexts {} ", (Object)this.kubernetesClientResource.getKubernetesClient().getConfiguration().getContexts().toString());
        Resource result = this.registerKubernetesClientInOSLResource();
        while (result == null) {
            try {
                logger.info("Cannot get resource for registerKubernetesClient. Retrying in 10 seconds");
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            result = this.registerKubernetesClientInOSLResource();
        }
        SharedInformerFactory sharedInformerFactory = this.kubernetesClientResource.getKubernetesClient().informers();
        SharedIndexInformer shixInformer = sharedInformerFactory.sharedIndexInformerFor(CustomResourceDefinition.class, 30000L);
        shixInformer.addEventHandler((ResourceEventHandler)new ResourceEventHandler<CustomResourceDefinition>(){

            public void onAdd(CustomResourceDefinition crd) {
                logger.debug("ADDED {} CRD:{} Group:{} Kind:{} UID:{} ", new Object[]{crd.getKind(), crd.getMetadata().getName(), crd.getSpec().getGroup(), crd.getSpec().getNames().getKind(), crd.getMetadata().getUid()});
                List<KubernetesCRDV1> rspec = WatcherService.this.kubernetesClientResource.KubernetesCRD2OpensliceCRD(crd);
                for (KubernetesCRDV1 rs : rspec) {
                    WatcherService.this.catalogClient.createOrUpdateResourceSpecByNameCategoryVersion(rs.toRSpecCreate());
                    WatcherService.this.catalogClient.createOrUpdateResourceByNameCategoryVersion(rs.toResourceCreate());
                }
                WatcherService.this.createCRDSharedIndexInformer(crd);
            }

            public void onUpdate(CustomResourceDefinition oldcrd, CustomResourceDefinition newcrd) {
                logger.debug("CRD_UPDATED {} {} for kind {}", new Object[]{newcrd.getKind(), newcrd.getSpec().getGroup(), newcrd.getSpec().getNames().getKind()});
                String oldLAC = (String)oldcrd.getMetadata().getAnnotations().get("kubectl.kubernetes.io/last-applied-configuration");
                String newLAC = (String)newcrd.getMetadata().getAnnotations().get("kubectl.kubernetes.io/last-applied-configuration");
                if (newLAC == null || !newLAC.equals(oldLAC)) {
                    logger.debug("\t NEWCRD:{} Group:{} Kind:{} UID:{} ", new Object[]{newcrd.getMetadata().getName(), newcrd.getSpec().getGroup(), newcrd.getSpec().getNames().getKind(), newcrd.getMetadata().getUid()});
                    logger.debug("UPDATED Resource Definition of {} ", (Object)newcrd.getKind());
                    logger.debug("\t Annotations:{} ", (Object)newcrd.getMetadata().getAnnotations().toString());
                }
            }

            public void onDelete(CustomResourceDefinition crd, boolean deletedFinalStateUnknown) {
                logger.debug("CRD_DELETED {}", (Object)crd.getKind());
                logger.debug("\t DELETEDCRD:{} Group:{} Kind:{} UID:{} ", new Object[]{crd.getMetadata().getName(), crd.getSpec().getGroup(), crd.getSpec().getNames().getKind(), crd.getMetadata().getUid()});
            }
        });
        sharedInformerFactory.startAllRegisteredInformers();
    }

    private Resource registerKubernetesClientInOSLResource() {
        try {
            ResourceCreate rsc = this.kubernetesClientResource.getKubernetesContextDefinition().toResourceCreate();
            Resource result = this.catalogClient.createOrUpdateResourceByNameCategoryVersion(rsc);
            return result;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    protected void createCRDSharedIndexInformer(final CustomResourceDefinition crd) {
        ResourceDefinitionContext context = new ResourceDefinitionContext.Builder().withGroup(crd.getSpec().getGroup()).withVersion(((CustomResourceDefinitionVersion)crd.getSpec().getVersions().get(0)).getName()).withKind(crd.getSpec().getNames().getKind()).withPlural(crd.getSpec().getNames().getPlural()).build();
        try {
            int n = ((GenericKubernetesResourceList)this.kubernetesClientResource.getKubernetesClient().genericKubernetesResources(context).list()).getItems().size();
        }
        catch (Exception e) {
            logger.error("Cannot create createCRDSharedIndexInformer. Seems there are no resources for kind: " + crd.getSpec().getNames().getKind());
            return;
        }
        logger.debug("Creating new Watcher for kind: {}", (Object)crd.getSpec().getNames().getKind());
        Watch watch = ((AnyNamespaceOperation)this.kubernetesClientResource.getKubernetesClient().genericKubernetesResources(context).inAnyNamespace()).watch((Watcher)new Watcher<GenericKubernetesResource>(){
            private String watcherResourcesName;

            public void eventReceived(Watcher.Action action, GenericKubernetesResource genericKubernetesResource) {
                this.watcherResourcesName = genericKubernetesResource.getKind();
                if (genericKubernetesResource.getKind().startsWith("IPAM")) {
                    return;
                }
                logger.debug("{} Resource Kind:{} Name:{} UID:{} Namespace:{} ", new Object[]{action.name(), genericKubernetesResource.getKind(), genericKubernetesResource.getMetadata().getName(), genericKubernetesResource.getMetadata().getUid(), genericKubernetesResource.getMetadata().getNamespace()});
                genericKubernetesResource.getAdditionalProperties().forEach((pk, pv) -> {
                    logger.debug("\t {} {} ", pk, pv);
                    if (pv instanceof Map) {
                        Map values = (Map)pv;
                        values.forEach((speck, specv) -> logger.debug("\t  {}={} ", speck, specv));
                    } else if (pv instanceof ArrayList) {
                        ArrayList values = (ArrayList)pv;
                        values.forEach(speck -> logger.debug("\t  {}={} ", speck));
                    }
                });
                if (action.name().equals("ADDED")) {
                    WatcherService.this.updateGenericKubernetesResourceInOSLCatalog(genericKubernetesResource);
                } else if (action.name().equals("MODIFIED")) {
                    WatcherService.this.updateGenericKubernetesResourceInOSLCatalog(genericKubernetesResource);
                } else if (action.name().equals("DELETED")) {
                    genericKubernetesResource.getMetadata().getLabels().put("org.etsi.osl.deleted", "DELETED");
                    WatcherService.this.updateGenericKubernetesResourceInOSLCatalog(genericKubernetesResource);
                }
            }

            public void onClose(WatcherException e) {
                logger.info("Closing resources Watcher of {} due to {} ", (Object)this.watcherResourcesName, (Object)e.getMessage());
                WatcherService.this.createCRDSharedIndexInformer(crd);
            }
        });
    }

    protected void updateGenericKubernetesResourceInOSLCatalog(GenericKubernetesResource genericKubernetesResource) {
        String oslResourceId = (String)genericKubernetesResource.getMetadata().getLabels().get("org.etsi.osl.resourceId");
        if (oslResourceId != null) {
            ResourceUpdate rs = this.kubernetesClientResource.KubernetesCR2OpensliceCR(genericKubernetesResource).toResourceUpdate();
            this.catalogClient.updateResourceById(oslResourceId, rs);
        } else {
            ResourceCreate rs = this.kubernetesClientResource.KubernetesCR2OpensliceCR(genericKubernetesResource).toResourceCreate();
            this.catalogClient.createOrUpdateResourceByNameCategoryVersion(rs);
        }
    }

    @PreDestroy
    ApplicationListener<ContextStoppedEvent> stop() {
        logger.info("Closing due to ContextStoppedEvent ");
        return event -> this.watch.close();
    }
}

