/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.cridge;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.etsi.osl.cridge.CatalogClient;
import org.etsi.osl.domain.model.kubernetes.KubernetesConfigMap;
import org.etsi.osl.domain.model.kubernetes.KubernetesSecret;
import org.etsi.osl.domain.model.kubernetes.KubernetesService;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecification;
import org.etsi.osl.tmf.ri639.model.ResourceCreate;
import org.etsi.osl.tmf.ri639.model.ResourceStatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class NamespaceWatcher {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.etsi.osl.cridge");
    private KubernetesClient kubernetesClient;
    private CatalogClient catalogClient;
    private String nameSpacename;
    private Map<String, Object> headers;
    private ResourceSpecification kubernetesSecretResourceSpec = null;
    private ResourceSpecification kubernetesServiceResourceSpec = null;
    private ResourceSpecification kubernetesConfigMapResourceSpec = null;
    List<SharedIndexInformer<?>> informers = new ArrayList();

    public NamespaceWatcher(KubernetesClient kubernetesClient, CatalogClient catalogClient, String anameSpacename, Map<String, Object> aheaders) {
        this.kubernetesClient = kubernetesClient;
        this.catalogClient = catalogClient;
        this.nameSpacename = anameSpacename;
        this.headers = aheaders;
        this.kubernetesSecretResourceSpec = catalogClient.retrieveResourceSpecByNameCategoryVersion("kubernetes-secret.openslice.io", "Secret/Kubernetes/v1", "0.0.3");
        this.kubernetesServiceResourceSpec = catalogClient.retrieveResourceSpecByNameCategoryVersion("kubernetes-service.openslice.io", "Service/Kubernetes/v1", "0.0.1");
        this.kubernetesConfigMapResourceSpec = catalogClient.retrieveResourceSpecByNameCategoryVersion("kubernetes-configmap.openslice.io", "ConfigMap/Kubernetes/v1", "0.0.1");
    }

    public static NamespaceWatcher getNew(KubernetesClient kubernetesClient2, CatalogClient catalogClient2, String anameSpacename, Map<String, Object> aheaders) {
        NamespaceWatcher aNamespaceWatchers = new NamespaceWatcher(kubernetesClient2, catalogClient2, anameSpacename, aheaders);
        SharedIndexInformer<Secret> rSecret = aNamespaceWatchers.createSecretWatchersFornamespace(anameSpacename, aheaders);
        aNamespaceWatchers.informers.add(rSecret);
        SharedIndexInformer<Service> rService = aNamespaceWatchers.createServiceWatcherssForNamespace(anameSpacename, aheaders);
        aNamespaceWatchers.informers.add(rService);
        SharedIndexInformer<ConfigMap> rCMap = aNamespaceWatchers.createConfigMapWatcherssForNamespace(anameSpacename, aheaders);
        aNamespaceWatchers.informers.add(rService);
        return aNamespaceWatchers;
    }

    private SharedIndexInformer<Secret> createSecretWatchersFornamespace(String nameSpacename, final Map<String, Object> headers) {
        SharedIndexInformer shixInformer = ((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(nameSpacename)).inform((ResourceEventHandler)new ResourceEventHandler<Secret>(){

            public void onAdd(Secret obj) {
                logger.debug("Added Namespace watcher Resource Kind:{} Name:{} UID:{} Namespace:{}", new Object[]{obj.getKind(), obj.getMetadata().getName(), obj.getMetadata().getUid(), obj.getMetadata().getNamespace()});
                headers.forEach((hname, hval) -> {
                    if (hval instanceof String) {
                        String s = (String)hval;
                        if (hname.contains("org.etsi.osl")) {
                            logger.debug("Header: {} = {} ", hname, (Object)s);
                            if (obj.getMetadata() == null) {
                                obj.setMetadata(new ObjectMeta());
                                obj.getMetadata().setLabels(new HashMap());
                            }
                            obj.getMetadata().getLabels().put(hname, s);
                        }
                    }
                });
                NamespaceWatcher.this.updateKubernetesSecretResourceInOSLCatalog(obj, false);
            }

            public void onUpdate(Secret oldObj, Secret newObj) {
                logger.debug("onUpdate Namespace watcher Resource Kind:{} Name:{} UID:{} Namespace:{}", new Object[]{newObj.getKind(), newObj.getMetadata().getName(), newObj.getMetadata().getUid(), newObj.getMetadata().getNamespace()});
                NamespaceWatcher.this.updateKubernetesSecretResourceInOSLCatalog(newObj, false);
            }

            public void onDelete(Secret obj, boolean deletedFinalStateUnknown) {
                logger.debug("onDelete Namespace watcher Resource Kind:{} Name:{} UID:{} Namespace:{}", new Object[]{obj.getKind(), obj.getMetadata().getName(), obj.getMetadata().getUid(), obj.getMetadata().getNamespace()});
                NamespaceWatcher.this.updateKubernetesSecretResourceInOSLCatalog(obj, true);
            }
        }, 30000L);
        shixInformer.start();
        return shixInformer;
    }

    private void updateKubernetesSecretResourceInOSLCatalog(Secret resource, boolean toDelete) {
        ResourceCreate rs = this.KubernetesSecret2OpensliceResource(resource).toResourceCreate();
        if (toDelete) {
            rs.setResourceStatus(ResourceStatusType.SUSPENDED);
        }
        this.catalogClient.createOrUpdateResourceByNameCategoryVersion(rs);
    }

    public KubernetesSecret KubernetesSecret2OpensliceResource(Secret secret) {
        String baseCRD = String.format("%s@%s@%s@%s", secret.getKind(), secret.getApiVersion(), this.kubernetesClient.getConfiguration().getCurrentContext().getContext().getCluster(), this.kubernetesClient.getMasterUrl().toExternalForm());
        KubernetesSecret kcrv = KubernetesSecret.builder().osl_KUBCRD_RSPEC_UUID(this.kubernetesSecretResourceSpec.getUuid()).name(secret.getMetadata().getName() + "@" + secret.getMetadata().getNamespace() + "@" + this.kubernetesClient.getConfiguration().getCurrentContext().getContext().getCluster() + "@" + this.kubernetesClient.getMasterUrl().toExternalForm()).version(secret.getApiVersion()).currentContextCluster(this.kubernetesClient.getConfiguration().getCurrentContext().getContext().getCluster()).clusterMasterURL(this.kubernetesClient.getMasterUrl().toString()).fullResourceName("").namespace(Serialization.asJson((Object)secret.getMetadata().getNamespace())).kind(secret.getKind()).apiGroup(secret.getPlural()).uID(secret.getMetadata().getUid()).metadata(Serialization.asJson((Object)secret.getMetadata())).description(String.format("A secret in namespace %s on %s", secret.getMetadata().getNamespace(), baseCRD)).build();
        secret.getMetadata().getLabels().forEach((pk, pv) -> {
            logger.debug("\t label: {} {} ", pk, pv);
            kcrv.getProperties().put(pk, pv);
        });
        if (secret.getData() != null) {
            secret.getData().forEach((kPropName, vProVal) -> {
                logger.debug("propName={} propValue={} ", kPropName, vProVal);
                kcrv.getData().put(kPropName, vProVal);
            });
        }
        if (secret.getStringData() != null) {
            secret.getStringData().forEach((kPropName, vProVal) -> {
                logger.debug("propName={} propValue={} ", kPropName, vProVal);
                kcrv.getProperties().put(kPropName, vProVal);
            });
        }
        kcrv.setDataObj(Serialization.asYaml((Object)secret.getData()));
        kcrv.setJson(Serialization.asJson((Object)secret));
        return kcrv;
    }

    private SharedIndexInformer<Service> createServiceWatcherssForNamespace(String nameSpacename, final Map<String, Object> headers) {
        SharedIndexInformer shixInformer = ((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(nameSpacename)).inform((ResourceEventHandler)new ResourceEventHandler<Service>(){

            public void onAdd(Service obj) {
                logger.debug("Added Namespace watcher Resource Kind:{} Name:{} UID:{} Namespace:{}", new Object[]{obj.getKind(), obj.getMetadata().getName(), obj.getMetadata().getUid(), obj.getMetadata().getNamespace()});
                headers.forEach((hname, hval) -> {
                    if (hval instanceof String) {
                        String s = (String)hval;
                        if (hname.contains("org.etsi.osl")) {
                            logger.debug("Header: {} = {} ", hname, (Object)s);
                            if (obj.getMetadata() == null) {
                                obj.setMetadata(new ObjectMeta());
                                obj.getMetadata().setLabels(new HashMap());
                            }
                            obj.getMetadata().getLabels().put(hname, s);
                        }
                    }
                });
                NamespaceWatcher.this.updateKubernetesServiceResourceInOSLCatalog(obj, false);
            }

            public void onUpdate(Service oldObj, Service newObj) {
                logger.debug("onUpdate Namespace watcher Resource Kind:{} Name:{} UID:{} Namespace:{}", new Object[]{newObj.getKind(), newObj.getMetadata().getName(), newObj.getMetadata().getUid(), newObj.getMetadata().getNamespace()});
                NamespaceWatcher.this.updateKubernetesServiceResourceInOSLCatalog(newObj, false);
            }

            public void onDelete(Service obj, boolean deletedFinalStateUnknown) {
                logger.debug("onDelete Namespace watcher Resource Kind:{} Name:{} UID:{} Namespace:{}", new Object[]{obj.getKind(), obj.getMetadata().getName(), obj.getMetadata().getUid(), obj.getMetadata().getNamespace()});
                NamespaceWatcher.this.updateKubernetesServiceResourceInOSLCatalog(obj, true);
            }
        }, 30000L);
        shixInformer.start();
        return shixInformer;
    }

    private void updateKubernetesServiceResourceInOSLCatalog(Service resource, boolean toDelete) {
        ResourceCreate rs = this.KubernetesService2OpensliceResource(resource).toResourceCreate();
        if (toDelete) {
            rs.setResourceStatus(ResourceStatusType.SUSPENDED);
        }
        this.catalogClient.createOrUpdateResourceByNameCategoryVersion(rs);
    }

    KubernetesService KubernetesService2OpensliceResource(Service serv) {
        String baseCRD = String.format("%s@%s@%s@%s", serv.getKind(), serv.getApiVersion(), this.kubernetesClient.getConfiguration().getCurrentContext().getContext().getCluster(), this.kubernetesClient.getMasterUrl().toExternalForm());
        KubernetesService kcrv = KubernetesService.builder().osl_KUBCRD_RSPEC_UUID(this.kubernetesServiceResourceSpec.getUuid()).name(serv.getMetadata().getName() + "@" + serv.getMetadata().getNamespace() + "@" + this.kubernetesClient.getConfiguration().getCurrentContext().getContext().getCluster() + "@" + this.kubernetesClient.getMasterUrl().toExternalForm()).version(serv.getApiVersion()).currentContextCluster(this.kubernetesClient.getConfiguration().getCurrentContext().getContext().getCluster()).clusterMasterURL(this.kubernetesClient.getMasterUrl().toString()).fullResourceName("").namespace(Serialization.asJson((Object)serv.getMetadata().getNamespace())).kind(serv.getKind()).apiGroup(serv.getPlural()).uID(serv.getMetadata().getUid()).metadata(Serialization.asJson((Object)serv.getMetadata())).description(String.format("A service in namespace %s on %s", serv.getMetadata().getNamespace(), baseCRD)).build();
        serv.getMetadata().getLabels().forEach((pk, pv) -> {
            logger.debug("\t label: {} {} ", pk, pv);
            kcrv.getProperties().put(pk, pv);
        });
        kcrv.setSpecObj(Serialization.asYaml((Object)serv.getSpec()));
        kcrv.setStatusObj(Serialization.asYaml((Object)serv.getStatus()));
        kcrv.setJson(Serialization.asJson((Object)serv));
        Map<String, String> resultMap = NamespaceWatcher.yamlToMap(kcrv.getSpecObj());
        kcrv.setSpec(resultMap);
        resultMap = NamespaceWatcher.yamlToMap(kcrv.getStatusObj());
        kcrv.setStatus(resultMap);
        return kcrv;
    }

    public static Map<String, String> yamlToMap(String yamlString) {
        Yaml yaml = new Yaml();
        Map yamlMap = (Map)yaml.load((Reader)new StringReader(yamlString));
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        NamespaceWatcher.flattenMap("", yamlMap, resultMap);
        return resultMap;
    }

    private static void flattenMap(String prefix, Map<String, Object> sourceMap, Map<String, String> resultMap) {
        for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
            String key = prefix.isEmpty() ? entry.getKey() : prefix + "." + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                NamespaceWatcher.flattenMap(key, (Map)value, resultMap);
                continue;
            }
            resultMap.put(key, value.toString());
        }
    }

    private SharedIndexInformer<ConfigMap> createConfigMapWatcherssForNamespace(String nameSpacename, final Map<String, Object> headers) {
        SharedIndexInformer shixInformer = ((NonNamespaceOperation)this.kubernetesClient.configMaps().inNamespace(nameSpacename)).inform((ResourceEventHandler)new ResourceEventHandler<ConfigMap>(){

            public void onAdd(ConfigMap obj) {
                logger.debug("Added Namespace watcher Resource Kind:{} Name:{} UID:{} Namespace:{}", new Object[]{obj.getKind(), obj.getMetadata().getName(), obj.getMetadata().getUid(), obj.getMetadata().getNamespace()});
                headers.forEach((hname, hval) -> {
                    if (hval instanceof String) {
                        String s = (String)hval;
                        if (hname.contains("org.etsi.osl")) {
                            logger.debug("Header: {} = {} ", hname, (Object)s);
                            if (obj.getMetadata() == null) {
                                obj.setMetadata(new ObjectMeta());
                                obj.getMetadata().setLabels(new HashMap());
                            }
                            obj.getMetadata().getLabels().put(hname, s);
                        }
                    }
                });
                NamespaceWatcher.this.updateKubernetesConfigMapResourceInOSLCatalog(obj, false);
            }

            public void onUpdate(ConfigMap oldObj, ConfigMap newObj) {
                logger.debug("onUpdate Namespace watcher Resource Kind:{} Name:{} UID:{} Namespace:{}", new Object[]{newObj.getKind(), newObj.getMetadata().getName(), newObj.getMetadata().getUid(), newObj.getMetadata().getNamespace()});
                NamespaceWatcher.this.updateKubernetesConfigMapResourceInOSLCatalog(newObj, false);
            }

            public void onDelete(ConfigMap obj, boolean deletedFinalStateUnknown) {
                logger.debug("onDelete Namespace watcher Resource Kind:{} Name:{} UID:{} Namespace:{}", new Object[]{obj.getKind(), obj.getMetadata().getName(), obj.getMetadata().getUid(), obj.getMetadata().getNamespace()});
                NamespaceWatcher.this.updateKubernetesConfigMapResourceInOSLCatalog(obj, true);
            }
        }, 30000L);
        shixInformer.start();
        return shixInformer;
    }

    private void updateKubernetesConfigMapResourceInOSLCatalog(ConfigMap resource, boolean toDelete) {
        ResourceCreate rs = this.KubernetesConfigMap2OpensliceResource(resource).toResourceCreate();
        if (toDelete) {
            rs.setResourceStatus(ResourceStatusType.SUSPENDED);
        }
        this.catalogClient.createOrUpdateResourceByNameCategoryVersion(rs);
    }

    KubernetesConfigMap KubernetesConfigMap2OpensliceResource(ConfigMap cmap) {
        String baseCRD = String.format("%s@%s@%s@%s", cmap.getKind(), cmap.getApiVersion(), this.kubernetesClient.getConfiguration().getCurrentContext().getContext().getCluster(), this.kubernetesClient.getMasterUrl().toExternalForm());
        KubernetesConfigMap kcrv = KubernetesConfigMap.builder().osl_KUBCRD_RSPEC_UUID(this.kubernetesConfigMapResourceSpec.getUuid()).name(cmap.getMetadata().getName() + "@" + cmap.getMetadata().getNamespace() + "@" + this.kubernetesClient.getConfiguration().getCurrentContext().getContext().getCluster() + "@" + this.kubernetesClient.getMasterUrl().toExternalForm()).version(cmap.getApiVersion()).currentContextCluster(this.kubernetesClient.getConfiguration().getCurrentContext().getContext().getCluster()).clusterMasterURL(this.kubernetesClient.getMasterUrl().toString()).fullResourceName("").namespace(Serialization.asJson((Object)cmap.getMetadata().getNamespace())).kind(cmap.getKind()).apiGroup(cmap.getPlural()).uID(cmap.getMetadata().getUid()).metadata(Serialization.asJson((Object)cmap.getMetadata())).description(String.format("A configMap in namespace %s on %s", cmap.getMetadata().getNamespace(), baseCRD)).build();
        cmap.getMetadata().getLabels().forEach((pk, pv) -> {
            logger.debug("\t label: {} {} ", pk, pv);
            kcrv.getProperties().put(pk, pv);
        });
        kcrv.setDataObj(Serialization.asYaml((Object)cmap.getData()));
        kcrv.setJson(Serialization.asJson((Object)cmap));
        Map<String, String> resultMap = NamespaceWatcher.yamlToMap(kcrv.getDataObj());
        kcrv.setData(resultMap);
        return kcrv;
    }

    public void disableNamespace(String ns) {
        ((NonNamespaceOperation)this.kubernetesClient.configMaps().inNamespace(ns)).delete();
        ((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(ns)).delete();
        ((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(ns)).delete();
    }
}

