package org.etsi.osl.cridge;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import org.apache.camel.util.json.JsonObject;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.dsl.Resource;

public class CreateResourceArgoJenkinsProgram {

	// @formatter:off
	public static void main(String[] args) {
		try (final KubernetesClient k8s = new KubernetesClientBuilder().build()) {
			
			
			
			JsonObject objSpec = new JsonObject();
			
		      objSpec.put("project", "default");
		      //obj.put("num", Integer.valueOf(100));
		      
		      JsonObject objdestination = new JsonObject();
		      	objdestination.put("namespace", "default");
		      	objdestination.put("name", "in-cluster");		      
		      objSpec.put("destination", objdestination);

		      JsonObject objsource = new JsonObject();
		      objsource.put("repoURL", "https://charts.jenkins.io");
		      objsource.put("targetRevision", "4.6.1");
		      objsource.put("chart", "jenkins");
		      JsonObject objvalues = new JsonObject();
		      objvalues.put("values", "controller:\n  service:\n    type: ClusterIP\n");
		      
		      
		      objsource.put("helm", objvalues);
		      objSpec.put("source", objsource);

			

				JsonObject objOperation = new JsonObject();
				JsonObject intiby = (new JsonObject());
				intiby.put("username", "testadmin");
				objOperation.put("initiatedBy",  intiby);
				JsonObject objsync = new JsonObject();
				objsync.put("prune", Boolean.valueOf(true));
				JsonObject syncStrategy = (new JsonObject());
				syncStrategy.put("hook", new JsonObject());
				objsync.put("syncStrategy", syncStrategy );
				objOperation.put("sync", objsync );
		      
			

			GenericKubernetesResource genericKubernetesResource = new GenericKubernetesResourceBuilder()
					.withApiVersion("argoproj.io/v1alpha1")
					.withKind("Application")
					.withNewMetadata()
					.withName( "openslice-jenkins" )
					.withNamespace( "argocd" )
					.addToFinalizers("resources-finalizer.argocd.argoproj.io")
					.endMetadata()
					.addToAdditionalProperties("spec", objSpec)
					.addToAdditionalProperties("operation", objOperation)
					.build();


			System.out.println(  Serialization.asYaml( genericKubernetesResource ) );

			System.out.println(  "=============as Json===========================" );
			System.out.println(  Serialization.asJson( genericKubernetesResource ) );
			
			Resource<GenericKubernetesResource> dummyObject = k8s.resource(genericKubernetesResource);
			// Create Custom Resource
			dummyObject.create();
			
/*
 * to delete we need: 
 * kubectl patch app ingress-nginx -n argocd -p '{"metadata": {"finalizers": ["resources-finalizer.argocd.argoproj.io"]}}' --type merge
 * kubectl delete app ingress-nginx -n argocd			
 */

		}
	}

}



/**
 * 
 * 
{
  "apiVersion": "argoproj.io/v1alpha1",
  "kind": "Application",
  "metadata": {
    "finalizers": [
      "resources-finalizer.argocd.argoproj.io"
    ],
    "name": "openslice-jenkins",
    "namespace": "argocd"
  },
  "spec": {
    "project": "default",
    "destination": {
      "namespace": "default",
      "name": "in-cluster"
    },
    "source": {
      "repoURL": "https://charts.jenkins.io",
      "targetRevision": "4.6.1",
      "chart": "jenkins",
      "helm": {
        "values": "controller:\n  service:\n    type: ClusterIP\n"
      }
    }
  },
  "operation": {
    "initiatedBy": {
      "username": "testadmin"
    },
    "sync": {
      "prune": true,
      "syncStrategy": {
        "hook": {}
      }
    }
  }
}
 * 
 */
