
# Exposing Kubernetes Operators as a Service : Offering "Calculator as a Service" through OpenSlice

## Intended Audience: Service Designers


To illustrate the powerful concept of Kubernetes operators and how they can be utilized to offer a service through OpenSlice, 
let's provide an example of a "Calculator as a Service." 
This example will demonstrate the flexibility and capabilities of Kubernetes operators in managing custom resources 
and automating operational tasks.

---
## Offering "Calculator as a Service" through OpenSlice

- We have a service that can accept two integers and an action (SUM, SUB, etc) and returns a result
- We would like to offer it as a Service through OpenSlice
- So when a user orders it with some initial parameters, OpenSlice will create it and return the result
- Also while the service is active, we can do further calculations, until we destroy it.


- Assume the following simple CRD of a calculator model accepting two params (spec section) and an action and returning a result (status section)
- The controller (the calculato code) is implemented in any language and is installed in a Kubernetes cluster

```

apiVersion: apiextensions.k8s.io/v1
kind: CustomResourceDefinition
metadata:
  name: mycalculators.examples.osl.etsi.org
spec:
  group: examples.osl.etsi.org
  names:
    kind: MyCalculator
    plural: mycalculators
    singular: mycalculator
  scope: Namespaced
  versions:
  - name: v1alpha1
    schema:
      openAPIV3Schema:
        properties:
          spec:
            properties:
              parama:
                type: integer
              paramb:
                type: integer
              action:
                type: string
            type: object
          status:
            properties:
              result:
                type: integer
              status:
                type: string
            type: object
        type: object
    served: true
    storage: true
    subresources:
      status: {}
```


Request to the cluster (through e.g. kubectl apply)

```
apiVersion: examples.osl.etsi.org/v1alpha1
kind: MyCalculator
metadata:
  name: mycalculator.examples.osl.etsi.org
spec:
  parama: 170
  paramb: 180
  action: 'SUM'

```

Response

```
apiVersion: examples.osl.etsi.org/v1alpha1
kind: MyCalculator
metadata:
  creationTimestamp: '2023-12-05T12:26:07Z’

<snip>

status:
  result: 350
  status: CALCULATED
spec:
  action: SUM
  parama: 170
  paramb: 180

```

To perform this through OpenSlice as a Service Specification ready to be ordered we need to do the following:

---
### CRD is saved automatically as Resource Specification

As soon as the CRD is deployed in the cluster (e.g. by your admin via kubctl or via any installation through the internet) it is automatically transformed and is available in OpenSlice catalogs as a Resource Specification.
- See also the fully qualified name of the resource specification.
- The resource specification name is quite unique, so you can install the CRD in many clusters around the internet. Each CRD on each cluster will appear here


<img src="img07.png" >


<img src="img08.png" width=1024px>

---
### Create a ResourceFacingServiceSpecification


<img src="img09.png" width=1024px>
<img src="img10.png" width=1024px>




### Creation of CRD-related characteristics

- We need now to adjust some characteristics of this CRD as Resoruce Specification.
- OpenSlice transalted automatically the CRD spec in a flat list of characteristics.So the "spec" section from the original yaml for example, is now unfold into: spec, spec.parama, spec.paramb, etc. the same for "status" object
- We need to make OpenSlice aware of when the service will be active. 
	- So we go to characteristic _CR_CHECK_FIELD and we define that the field that shows the status of the service is the characteristic "status.status" (is a text field) 
	- Then we go to _CR_CHECKVAL_AVAILABLE and we define the value CALCULATED, which signals the following: When the characteristic "status.status" has the value "CALCULATED" then OpenSlice will mark the underlying service as "ACTIVE"
	- We need also to define the yaml file that OpenSLice will use to create the new resource in the kubernetes cluster
	- We insert the YAML in the characteristic _CR_SPEC
	
	the _CR_SPEC is: ```
apiVersion: examples.osl.etsi.org/v1alpha1
kind: MyCalculator
metadata:
  name: mycalculator.examples.osl.etsi.org
spec:
  parama: 170
  paramb: 180
  action: 'SUM'

```
	
<img src="img11.png" width=1024px>


> However the values are fixed. How do we allow a user to pass parameters through OpenSlice

### Pass parameters through OpenSlice

We need to Create LCM rules in ResourceFacingServiceSpecification
- The goal of the rules is to allow the user to pass parameters to the actual resource towards the cluster.
- we will create one rule that will pass the parameters just before creating the service (PRE_PROVISION phase)
- we will create one rule that will pass the parameters while the service is active (SUPERVISION phase)
- The rules will be the same

<img src="img12.png" width=1024px>

If we see one rule it will look like the following:
<img src="img13.png" width=1024px>

- We need to change the _CR_SPEC characteristic
- We use a block that changes a String according to variables
- See that we have as Input string the YAML string lines
	- see that parama, paramb has a %d (they accept integers), action is %s (accepts a string)
	- See that the variables tha will replace the %d, %d and %s are an list
		- the first %d will be replaced with the value from characteristic spec.parama
		- the second %d will be replaced with the value from characteristic spec.paramb
		- the %s will be replaced with the value from characteristic spec.action
		
		

### Create a CustomerFacingServiceSpecification

We will now expose it to our users by creating a CustomerFacingServiceSpecification

<img src="img14.png" width=1024px>

Expose it then to a catalogue for orders through the Service Categories and Service Catalogs


<img src="img15.png">


### Order the Service

When a user orders the service, it will look like this:

<img src="img16.png" width=1024px>



- After the Service Order we have 2 services in service inventory on CFS and on RFS. Both have references to values
- OpenSlice (via CRIDGE service) updates the Resource in Resource Inventory and OSOM updates the Services in Service Inventory
- The Actual resources are running in the Kubernetes cluster managed by OpenSlice
- The result is in the characteristic status.result

<img src="img17.png" width=800px>

<img src="img18.png" width=1024px>

 ### Modify the running service
 
 The use can modify the service
 
<img src="img19.png" width=1024px>
 
- After a while the update is applied to the cluster, the controller will pick up the resource update and patch the resource
- OpenSlice (via CRIDGE service) updates the Resource in Resource Inventory and OSOM updates the Services in Service Inventory
    	

<img src="img20.png" width=1024px>
    	