package org.etsi.osl.cridge;

import java.net.HttpURLConnection;
import java.util.ArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.etsi.osl.tmf.ri639.model.ResourceCreate;
import org.junit.Rule;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import jakarta.annotation.PostConstruct;
import org.springframework.test.context.event.RecordApplicationEvents;
import org.springframework.test.context.event.annotation.BeforeTestClass;
import org.springframework.test.context.junit4.SpringRunner;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.NamedContextBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionList;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionListBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.extension.ExtensionAdapter.ClientFactory;
import io.fabric8.kubernetes.client.http.HttpClient.Factory;
import io.fabric8.kubernetes.client.server.mock.EnableKubernetesMockClient;
import io.fabric8.kubernetes.client.server.mock.KubernetesClientBuilderCustomizer;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServer;
import io.fabric8.kubernetes.client.server.mock.KubernetesServer;

@RecordApplicationEvents
@RunWith(SpringRunner.class)
@SpringBootTest(properties = {

    "kubernetes.master = test_kube",
    "spring.activemq.brokerUrl = vm://embedded?broker.persistent=false,useShutdownHook=false",
    "CATALOG_GET_RESOURCESPEC_BY_ID = direct:get_rspec_byid",
    "CATALOG_GET_RESOURCESPEC_BY_ΝAME_CATEGORY = direct:get_rspec_byNameCategory",
    "CATALOG_UPDADD_RESOURCE = direct:updadd_resource",})


@EnableKubernetesMockClient
public class CridgeIntegrationTest {
  private static final Logger logger = LoggerFactory.getLogger("org.etsi.osl.cridge");

  private static KubernetesMockServer server;

  @Autowired
  CatalogClient catalogClient;


  /**
   * it is used to override beans and setup the environment before application context starts
   */
  @TestConfiguration
  static class routesPreparation {

    @Autowired
    private CamelContext camelContext;

    private SCMocked scmocked = new SCMocked();

    private KubernetesClient kubernetesClient;

    @Autowired
    KubernetesClientResource aKubernetesClientResource;

    RoutesBuilder builder = new RouteBuilder() {
      @Override
      public void configure() {
        from("direct:get_rspec_byid").bean(scmocked, "getRspecID");
        from("direct:get_rspec_byNameCategory").bean(scmocked,
            "get_rspec_byNameCategory(${header.aname}, ${header.acategory}, ${header.aversion})");
        from("direct:updadd_resource").unmarshal()
            .json(JsonLibrary.Jackson, ResourceCreate.class, true).bean(scmocked,
                "updadd_resource(${header.aname},${header.acategory}, ${header.aversion}, ${body})");

      };
    };


    @EventListener(ApplicationStartedEvent.class)
    public void preparedForTheTest() {
      logger.info("=============== Created routes for the test and initialise =============== ");

      NamedContext nctx = new NamedContextBuilder().withNewContext().withCluster("testCluster")
          .and().withName("tstContext").build();

      KubernetesClientBuilderCustomizer zzz = new KubernetesClientBuilderCustomizer();
      Config config = Config.autoConfigure(null);
      config.setNamespace("testNamespace");
      KubernetesClientBuilder xxx = new KubernetesClientBuilder().withConfig(config);
      zzz.accept(xxx);
      kubernetesClient = server.createClient(zzz);
      kubernetesClient.getConfiguration().setCurrentContext(nctx);


      aKubernetesClientResource.setKubernetesClient(kubernetesClient);
      logger.info("Starting preparedForTheTest kubernetesClient.toString() {} ",
          kubernetesClient.toString());
      logger.info("Starting preparedForTheTest for cluster getContexts {} ",
          kubernetesClient.getConfiguration().getContexts().toString());

      
   ListMeta metada = new ListMetaBuilder().build();
      // Given
      CustomResourceDefinitionList list = new CustomResourceDefinitionListBuilder()
          .withMetadata(metada )
          .build();
      
            
      //the following expects are for the sharedIndexInformers in the beginning
      server.expect()
        .get()
            .withPath("/apis/apiextensions.k8s.io/v1/customresourcedefinitions?resourceVersion=0")
            .andReturn(HttpURLConnection.HTTP_OK, list )
            .once();

      server.expect()
      .get()
          .withPath("/apis/apiextensions.k8s.io/v1/customresourcedefinitions?allowWatchBookmarks=true&timeoutSeconds=600&watch=true")
          .andReturn(HttpURLConnection.HTTP_OK, list )
          .once();
      
      try {
        camelContext.addRoutes(builder);
      } catch (Exception e) {
        e.printStackTrace();
      }
    }
  }

  @BeforeTestClass
  public void beforeTestClass(ContextRefreshedEvent event) {
    logger.info("=============== beforeTestClass =============================");



  }


  @Test
  public void testCatalog() throws Exception {
    logger.info("===============TEST testCatalog =============================");



  }


}
