@startuml
queue MQ
control "KubernetesClientResource" as KubeClientResource
participant "KubernetesClient" as KubeClient
entity "GenericKubernetesResource" as ResourceObj
participant "Namespace" as NamespaceDB

MQ -> KubeClientResource : deployCR(headers, crspec)

alt check if this cridge can handle the CRSPEC\ncurrentContextCluster, clusterMasterURL
	
	KubeClientResource --> MQ : Response (SEE OTHER)
end

activate KubeClientResource

KubeClientResource -> KubeClient : new KubernetesClientBuilder()
activate KubeClient
KubeClient --> KubeClientResource : k8s
deactivate KubeClient


KubeClientResource -> NamespaceDB : Try creating Namespace
activate NamespaceDB
NamespaceDB --> KubeClientResource : Namespace Created / Exists
deactivate NamespaceDB

KubeClientResource -> KubeClientResource : createWatchersFornamespace()


activate KubeClientResource


KubeClientResource -> SharedInformer : KubernetesClient.secrets().inNamespace(nameSpacename).inform(new ResourceEventHandler<>())

loop For each Secret Event
    SharedInformer -> EventHandler : onAdd()/onUpdate()/onDelete()
    activate EventHandler
    EventHandler -> KubeClientResource : updateKubernetesSecretResourceInOSLCatalog
    deactivate EventHandler
end

deactivate KubeClientResource


KubeClientResource -> ResourceObj : k8s.resource(gkr)
activate ResourceObj
ResourceObj --> KubeClientResource : Creation Response
deactivate ResourceObj

KubeClientResource --> MQ : Response (OK / FAIL)
deactivate KubeClientResource
@enduml
