/*-
 * ========================LICENSE_START=================================
 * org.etsi.osl.osom
 * %%
 * Copyright (C) 2019 openslice.io
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
package org.etsi.osl.cridge;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.etsi.osl.tmf.ri639.model.Resource;
import org.etsi.osl.tmf.ri639.model.ResourceCreate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class SCMocked {


  private static final Logger logger = LoggerFactory.getLogger("org.etsi.osl.cridge");


  private static Map<String, org.etsi.osl.tmf.sim638.model.Service> runningServices =
      new HashMap<>();



  public String getRspecID(String id) throws IOException {
    logger.info("getRspecID id= " + id);
    File sspec = new File("src/test/resources/TestExServiceOrder.json");
    InputStream in = new FileInputStream(sspec);
    String sspectext = IOUtils.toString(in, "UTF-8");

    return sspectext;
  }

  
  public String get_rspec_byNameCategory(String aname, String aCategory, String aVersion) throws IOException {
    logger.info("get_rspec_byNameCategory {} {} {} ", aname, aCategory, aVersion);

    File sspec = null;
    if (aname.equals("kubernetes-context-definition.openslice.io")) {
      sspec = new File("src/test/resources/kubernetes-context-definition.openslice.io.json");
      
    } else if (aname.equals("kubernetes-crd.openslice.io")) {
      sspec = new File("src/test/resources/kubernetes-crd.openslice.io.json");      
    } else if (aname.equals("kubernetes-cr-v1.openslice.io")) {
      sspec = new File("src/test/resources/kubernetes-cr-v1.openslice.io.json");      
    } else if (aname.equals("kubernetes-secret.openslice.io")) {
      sspec = new File("src/test/resources/kubernetes-secret.openslice.io.json");      
    }
    
    
    
    
    InputStream in = new FileInputStream(sspec);
    String sspectext = IOUtils.toString(in, "UTF-8");

    return sspectext;
  }

  public String updadd_resource(String aName, String aCategory,
      String aVersion, ResourceCreate aResourceCreate) throws IOException {
    logger.info("updadd_resource {} {} {} {}", aName, aCategory, aVersion, aResourceCreate);

    Resource r = new Resource().name( aResourceCreate.getName() ); 

    return toJsonString(r);
  }


  public String getServiceById(String id) throws IOException {

    logger.info("getServiceById id = " + id);

    String sspectext = null;

    if (runningServices.get(id) != null) {
      org.etsi.osl.tmf.sim638.model.Service serviceInstance = runningServices.get(id);
      sspectext = toJsonString(serviceInstance);
      return sspectext;
    }


    File sspec = new File("src/test/resources/TestService.json");
    InputStream in = new FileInputStream(sspec);
    sspectext = IOUtils.toString(in, "UTF-8");
    return sspectext;
  }



  static String toJsonString(Object object) throws IOException {
    ObjectMapper mapper = new ObjectMapper();
    mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    return mapper.writeValueAsString(object);
  }

  static <T> T toJsonObj(String content, Class<T> valueType) throws IOException {
    ObjectMapper mapper = new ObjectMapper();
    mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    return mapper.readValue(content, valueType);
  }



}
