# Expose HELM charts as Service Specifications
Manage Helm charts installations via OpenSlice Service Specifications and Service Orders.
## Intended Audience: Service Designers


> Kubernetes is an orchestration system for automating software deployment, scaling, and management. One can interact though the Kubernetes API and it has a set of objects ready for use out of the box. 

> Helm is a tool that automates the creation, packaging, configuration, and deployment of Kubernetes applications by combining your configuration files into a single reusable package

> At the heart of Helm is the packaging format called charts. Each chart comprises one or more Kubernetes manifests -- and a given chart can have child charts and dependent charts, as well. Using Helm charts:

>       - Reduces the complexity of deploying Microservices

>       - Enhances deployment speed

>       - Developers already know the technology

> There are many Helm charts and Helm repositories there that are ready to be used

> Enable loose coupling and more orchestration scenarios

>	Developers create and deploy applications in things they already know (e.g. Helm charts)

> Use the TMF models as wrapper entities around Helm charts


Use OpenSlice to expose them in service catalogs and deploy them in complex scenarios (service bundles) involving also other systems:

	- Include e.g. RAN controllers, 
	- Pass values through life cycle rules from one service to another, 
	- Manage multiple Helms in multiple clusters


**The installation of HELM charts is based on OpenSlice CRD support**

Please read more [here](../ExposingKubernetesResources.md)


For installing HELM charts we will use ArgoCD a well known Kubernetes-native continuous deployment (CD) tool 

> ArgoCD is a Kubernetes-native continuous deployment (CD) tool

> While just deploying Heml charts is just a scenario for ArgoCD , in future one can exploit it for many things

> Despite some other tools like FluxCD, it provides also a UI which is useful for management and troubleshooting


We will mainly use the CRD of ```Kind: Application``` that ArgoCD can manage



Before proceeding, install ArgoCD in your management cluster, by following ArgoCD instructions

As soon as you install ArgoCD, OpenSlice is automatically aware for specific new Kinds. The one we care is the ```Kind: Application``` that ArgoCD can manage under the apiGroup argoproj.io

Browse to Resource Specifications. You will see an entry like the following:

```Application@argoproj.io/v1alpha1@kubernetes@https://10.10.10.144:6443/```

see image: 

<img src="img01.png" width=1024px>
 
# Example: Offer Jenkins as a Service via Openslice

We will use the ```Kind: Application``` of ArgoCD and create a  ResourceFacingServiceSpecification for Jenkins
	1. Go to Service Specifications
	2. Create New Specification
	3. Give a Name, eg. jenkinsrfs
	4. Go to Resource Specification Relationships
	5. Assign ```Application@argoproj.io/v1alpha1@kubernetes@https://10.10.10.144:6443/```

<img src="img02.png" width=640px>


Focus now on the characteristics configuration.

First we need to map the lifecycle of ArgoCD Application to TMF Resource State


<img src="img05.png" width=640px>

In ArgoCD the field **health.status** has the value that we need to check (Healty, Progressing, etc)
 
 
The _CR_SPEC can be designed first in a YAML or json editor. Let's see a YAML definition:

 
 ```

apiVersion: argoproj.io/v1alpha1
kind: Application
metadata:
  finalizers:
  - resources-finalizer.argocd.argoproj.io
  name: openslice-jenkins
  namespace: argocd
spec:
  project: default
  destination:
    namespace: opencrdtest
    name: in-cluster
  source:
    repoURL: https://charts.jenkins.io
    targetRevision: 4.6.1
    chart: jenkins
    helm:
      values: |
        controller:
         service:
         type: ClusterIP
  syncPolicy:
    automated:
      prune: true
      selfHeal: true
      allowEmpty: false
    syncOptions:
    - Validate=false
    - CreateNamespace=true
    - PrunePropagationPolicy=foreground
    - PruneLast=true
    - RespectIgnoreDifferences=true
```
 
**NOTICE**

On each installation OSOM will change the name of the resource in order to be unique (will have a UUID)

 ```name: openslice-jenkins``` 
 
 destination namespace that ArgoCD will use is the name ```opencrdtest```
 
 ```destination:
    namespace: opencrdtest
 ```
 
**This causea an issue that ArgoCD installs the Jenkins akways in the same namespace**
 
**To avoid this we will create a simple pre-provision rule to change the namespace properly**

See the following image: 
<img src="img06.png" >
 
1. Drag-Drop the _CR_SPEC characteristic of jenkinsrfs from the Service>Text blocks
2. Drag-Drop Text>Formatted text block
3. Drag-Drop Text>Multi-line text input block
4. Copy paste the YAML text
5. Change the spec: destination:namespace to the value %s
6. Drag-Drop Lists>Create list with block delete 2 items (click the gear icon). Connect it to formatted text block
7. Drag-Drop Context>Current Service Order block and select the id. Connect it to the List
8. Save the PRE_PROVISION Rule


Expose then as CustomerFacingServiceSpecification by using the previous RFSS as Service Specification Relationship 
1. Create a Jenkins service and mark as Bundle and save it 
2. Go to Service Specification Relationships and assign Jenkinsrfs
3. Add also a Logo if you wish

<img src="img03.png" width=640px>
<img src="img04.png" width=640px>
 
Expose it now to a Category and a Catalog to be available for ordering. Y
 
#Order the service

Order the service from the catalog. Soon the order will be completed and the Services will be active


<img src="img07.png" width=640px>

# How to access the Jenkins installation:

From the Supporting services of the Service Order, select the ResourceFacingService (jenkinsrfs)

The ResourceFacingService has also supporting resources in resource inventory.

<img src="img08.png" width=640px>

One is the resource reference to the application (e.g. _cr_tmpname_...), the other is a secret (e.g. cr87893...). 

Click to go to the secret resource (This is in the Resource inventory of OpenSlice)

<img src="img09.png" width=640px>

Use them to login in your Jenkins.


> Exposing Jenkins to you external is a matter of cluster configuration and request (nodeport, load balancing, etc)! This is not a topic for this example






