package org.etsi.osl.cridge;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.Watcher.Action;
import io.fabric8.kubernetes.client.utils.Serialization;

public class GetResourcesOfNamespace {


  // @formatter:off
  public static void main(String[] args) throws InterruptedException {
    try (final KubernetesClient k8s = new KubernetesClientBuilder().build()) {


      Namespace ns = new NamespaceBuilder()
          .withNewMetadata()
          .withName( "opencrdtest" )
          .endMetadata().build();



      for (Secret secret : k8s.secrets().inNamespace("opencrdtest").list().getItems() ) {
        System.out.println( Serialization.asYaml( secret ) );
      }

      for (Service secret : k8s.services().inNamespace("opencrdtest").list().getItems() ) {
        System.out.println( Serialization.asYaml( secret ) );
      }

      for (ConfigMap secret : k8s.configMaps().inNamespace("opencrdtest").list().getItems() ) {
        System.out.println( Serialization.asYaml( secret ) );
      }



    }
    
    try (final KubernetesClient k8s = new KubernetesClientBuilder().build()) {
      Watch watch = k8s.secrets().inNamespace( "16cce858-2f99-4f8f-afe6-9e1f21a78880").watch( new Watcher<>() {

        @Override
        public void eventReceived(Action action, Secret resource) {

          System.out.println(String.format("%s Namespace watcher Resource Kind:%s Name:%s UID:%s Namespace:%s", action.name(),
              resource.getKind(), 
              resource.getMetadata().getName(),
              resource.getMetadata().getUid(),
              resource.getMetadata().getNamespace()));
          //ADDED, DELETED, MODIFIED, BOOKMARK, ERROR
         

        }



        @Override
        public void onClose(WatcherException cause) {
          System.out.println(String.format("Closing resources Watcher of nameSpace due to %s "+cause.getMessage()));
          return;
        }

      });
      Thread.sleep(60 * 1000L);
      watch.close();
    }
    

    
    
  }
  
  

}
