package org.etsi.osl.cridge;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.dsl.Resource;

public class CreateResourceArgoNginx {


	// @formatter:off
	public static void main(String[] args) {
		try (final KubernetesClient k8s = new KubernetesClientBuilder().build()) {

			String yamlfile = 
"""			
apiVersion: argoproj.io/v1alpha1
kind: Application
metadata:
  name: ingress-nginx
  namespace: argocd
spec:
  project: default
  destination:
    namespace: default
    #update namespace name if you wish
    name: in-cluster   #update cluster name if its different
  source:
    repoURL: https://kubernetes.github.io/ingress-nginx
    targetRevision: "4.4.0"
    chart: ingress-nginx
    helm:
      values: |
        controller:
          service:
            type: ClusterIP
operation:
  initiatedBy:
    username: %s
    		
  sync:
    prune: true
    syncStrategy:
      hook: {}

""".formatted( "myuser" );
			

			System.out.println( yamlfile );
			GenericKubernetesResource gkr =  Serialization.unmarshal(yamlfile);
			
		              
			Resource<GenericKubernetesResource> dummyObject = k8s.resource( gkr );
			dummyObject.create();
			
/*
 * to delete we need: 
 * kubectl patch app ingress-nginx -n argocd -p '{"metadata": {"finalizers": ["resources-finalizer.argocd.argoproj.io"]}}' --type merge
 * kubectl delete app ingress-nginx -n argocd			
 */

		}
	}

}
