@startuml
actor Participant as caller
boundary    OSLAPI    as oslapirest
control     OSLC     as oslapi
control     OSOM     as osom
control     CRIDGE     as cridge
control     MGMK8S     as mgtk8s
control     ARGOCD     as argo
control     K8SaaSCRD     as k88ascrd

caller -> oslapirest : Create Service Order for K8SaaS spec\n (With ACKNOWLEDGED state)
oslapirest -> oslapi: Create\nService\nOrder
osom -> oslapi: Fetch ACK\norders
activate osom
osom -> osom: Process orders
osom -> cridge: Deploy CR App
note right
 This CR is matched with equivalent
 Resource in RI (ref resourceId)
end note
cridge -// mgtk8s: Create CR
note right
 here we label this CR with resourceId
end note
cridge -> cridge: Start watching\nSO namespace
cridge -> osom: response OK
osom -> oslapi: Order is INPROGRESS \n (services are created\nin RESERVED)

mgtk8s -> argo: Create CR
argo -> k88ascrd: Create CR
argo -// mgtk8s: CR status
mgtk8s -// cridge: CRs watch
group sync and reconciliation
 cridge -// oslapi: Update equivalent resource in RI of this CR\n(ref resourceId)
 oslapi -> oslapi: EVENT_RESOURCE_STATE_CHANGED
 mgtk8s -// cridge: Secrets watch
 cridge -// oslapi: Add/Update equivalent secret resource in RI of this CR\n(ref resourceId)
 note right
 org.etsi.osl.* labels are added
 so this resource can be managed by OSL
 end note
 oslapi -> oslapi: EVENT_RESOURCE_STATE_CHANGED
 note left
 SIM638 needs to take this event in case 
 this Resource is related 
 to a specific supporting resource
 (see resourceStateChangedEvent() and
 updateResourceFromKubernetesLabel() )
 Any resources that has characteristic org.etsi.osl.serviceId equals to a service
 are automatically added as supportingResources of this Service
 end note
end

osom -> osom: Wait all Active or Failures
note left
Wait for all services and
underlying resources
to be Active or Failed
end note
osom -> osom: Order is COMPLETED
osom -> oslapi: Order is COMPLETED
deactivate osom

group sync and reconciliation (continuous process)
 mgtk8s -// cridge: CRs watch
 cridge -// oslapi: Update equivalent resource in RI of this CR\n(ref resourceId)
 oslapi -> oslapi: EVENT_RESOURCE_STATE_CHANGED
 mgtk8s -// cridge: Secrets watch
 cridge -// oslapi: Add/Update equivalent secret resource in RI of this CR\n(ref resourceId)
 oslapi -> oslapi: EVENT_RESOURCE_STATE_CHANGED
end



caller -> oslapirest : request Service Order (by id)
activate caller
caller <- oslapirest : Service Order
caller -> caller : examine supportingService list
caller -> oslapirest : request Service (by id)
activate caller #FFDDDD
group focus only on the Resource Facing Service
caller -> caller : examine supportingResource list of this RFS
caller -> oslapirest : request Resource (by id) (tf-output@...) 
caller <- oslapirest : Resource from Inventory
caller -> caller :get characteristics kubeconf
caller -> oslapirest : request Resource (by id) (tfstate-...) 
caller <- oslapirest : Resource from Inventory
caller -> caller :get characteristic tfstate
end
deactivate caller
deactivate caller
@enduml
