@startuml
participant "WatcherService" as Watcher
participant "SharedInformerFactory" as InformerFactory
participant "SharedIndexInformer<CRD>" as IndexInformer
participant "CustomResourceDefinition" as CRD
participant "ResourceEventHandler<CRD>" as EventHandler
database "CatalogClient" as Catalog

Watcher -> InformerFactory : getKubernetesClient().informers()
activate InformerFactory
InformerFactory --> Watcher : sharedInformerFactory
deactivate InformerFactory

Watcher -> IndexInformer : sharedInformerFactory.sharedIndexInformerFor(CRD, 30 * 1000L)
activate IndexInformer
IndexInformer --> Watcher : shixInformer
deactivate IndexInformer

Watcher -> IndexInformer : addEventHandler(new ResourceEventHandler<CRD>())
activate IndexInformer
IndexInformer -> EventHandler : onAdd(CRD)
activate EventHandler
EventHandler -> Catalog : createOrUpdateResourceSpecByNameCategoryVersion()
EventHandler -> Catalog : createOrUpdateResourceByNameCategoryVersion()
activate Catalog
Catalog --> EventHandler : Response
deactivate Catalog
EventHandler --> IndexInformer : onAdd Completed
EventHandler -> Watcher : createCRDSharedIndexInformer
deactivate EventHandler

IndexInformer -> EventHandler : onUpdate(oldCRD, newCRD)
activate EventHandler
EventHandler --> IndexInformer : onUpdate Completed
deactivate EventHandler

IndexInformer -> EventHandler : onDelete(CRD, deletedFinalStateUnknown)
activate EventHandler
EventHandler --> IndexInformer : onDelete Completed
deactivate EventHandler

deactivate IndexInformer
@enduml