/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.bugzilla;

import jakarta.annotation.PostConstruct;
import javax.net.ssl.TrustManager;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpMethods;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.etsi.osl.bugzilla.BugzillaClient;
import org.etsi.osl.bugzilla.BugzillaRouteBuilder;
import org.etsi.osl.model.nfv.CompositeExperimentOnBoardDescriptor;
import org.etsi.osl.model.nfv.CompositeVxFOnBoardDescriptor;
import org.etsi.osl.model.nfv.DeploymentDescriptor;
import org.etsi.osl.model.nfv.ExperimentOnBoardDescriptor;
import org.etsi.osl.model.nfv.PortalUser;
import org.etsi.osl.model.nfv.ValidationStatus;
import org.etsi.osl.model.nfv.VxFOnBoardedDescriptor;
import org.etsi.osl.tmf.pm632.model.IndividualCreateEvent;
import org.etsi.osl.tmf.so641.model.ServiceOrderAttributeValueChangeNotification;
import org.etsi.osl.tmf.so641.model.ServiceOrderCreateNotification;
import org.etsi.osl.tmf.so641.model.ServiceOrderDeleteNotification;
import org.etsi.osl.tmf.so641.model.ServiceOrderStateChangeNotification;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class BugzillaRouteBuilder
extends RouteBuilder {
    @Value(value="${bugzillaurl}")
    private String BUGZILLAURL = "localhost:443/bugzilla";
    @Value(value="${bugzillakey}")
    private String BUGZILLAKEY = "";
    @Value(value="${EVENT_SERVICE_ORDER_CREATE}")
    private String EVENT_SERVICE_ORDER_CREATE = "";
    @Value(value="${EVENT_SERVICE_ORDER_STATE_CHANGED}")
    private String EVENT_SERVICE_ORDER_STATE_CHANGED = "";
    @Value(value="${EVENT_SERVICE_ORDER_DELETE}")
    private String EVENT_SERVICE_ORDER_DELETE = "";
    @Value(value="${EVENT_SERVICE_ORDER_ATTRIBUTE_VALUE_CHANGED}")
    private String EVENT_SERVICE_ORDER_ATTRIBUTE_VALUE_CHANGED = "";
    @Value(value="${EVENT_SERVICE_CREATE}")
    private String EVENT_SERVICE_CREATE = "";
    @Value(value="${EVENT_SERVICE_STATE_CHANGED}")
    private String EVENT_SERVICE_STATE_CHANGED = "";
    @Value(value="${EVENT_SERVICE_DELETE}")
    private String EVENT_SERVICE_DELETE = "";
    @Value(value="${EVENT_SERVICE_ATTRIBUTE_VALUE_CHANGED}")
    private String EVENT_SERVICE_ATTRIBUTE_VALUE_CHANGED = "";
    @Value(value="${EVENT_INDIVIDUAL_CREATE}")
    private String EVENT_INDIVIDUAL_CREATE = "";
    private static final transient Log logger = LogFactory.getLog((String)BugzillaRouteBuilder.class.getName());
    private static final TrustManager[] DUMMY_TRUST_MANAGERS = new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
    Predicate issueExists = new /* Unavailable Anonymous Inner Class!! */;
    Processor BugHeaderExtractProcessor = new /* Unavailable Anonymous Inner Class!! */;

    @PostConstruct
    public void postConstruct() {
        System.out.println("** bugzilla.host: " + this.BUGZILLAURL);
        System.out.println("** bugzilla.key: " + this.BUGZILLAKEY);
    }

    public void configure() {
        HttpComponent httpComponent = (HttpComponent)this.getContext().getComponent("https", HttpComponent.class);
        httpComponent.setHttpClientConfigurer((HttpClientConfigurer)new MyHttpClientConfigurer(this));
        Object usedBUGZILLAURL = "https://" + this.BUGZILLAURL;
        if (this.BUGZILLAURL.contains("http:")) {
            usedBUGZILLAURL = this.BUGZILLAURL;
        } else if (this.BUGZILLAURL.contains("https:")) {
            usedBUGZILLAURL = this.BUGZILLAURL.replace("https", "https");
        }
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:bugzilla.newIssue").marshal().json(JsonLibrary.Jackson, true).convertBodyTo(String.class)).to("stream:out")).setHeader("CamelHttpMethod", (Expression)this.constant((Object)HttpMethods.POST))).toD((String)usedBUGZILLAURL + "/rest.cgi/bug?api_key=" + this.BUGZILLAKEY + "&throwExceptionOnFailure=true")).to("log:DEBUG?showBody=true&showHeaders=true")).to("stream:out");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:bugzilla.updateIssue").marshal().json(JsonLibrary.Jackson, true).convertBodyTo(String.class)).to("stream:out")).errorHandler((ErrorHandlerFactory)this.deadLetterChannel("direct:dlq_bugzilla").maximumRedeliveries(4).redeliveryDelay(60000L).useOriginalMessage().logExhausted(true).logHandled(true).retryAttemptedLogLevel(LoggingLevel.WARN)).setHeader("CamelHttpMethod", (Expression)this.constant((Object)HttpMethods.PUT))).toD((String)usedBUGZILLAURL + "/rest.cgi/bug/${header.uuid}?api_key=" + this.BUGZILLAKEY + "&throwExceptionOnFailure=true")).to("log:DEBUG?showBody=true&showHeaders=true")).to("stream:out");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("activemq:topic:users.create").routeId("users-create-route").unmarshal().json(JsonLibrary.Jackson, PortalUser.class, true).bean(BugzillaClient.class, "transformUser2BugzillaUser")).marshal().json(JsonLibrary.Jackson, true).convertBodyTo(String.class)).to("stream:out")).setHeader("CamelHttpMethod", (Expression)this.constant((Object)HttpMethods.POST))).toD((String)usedBUGZILLAURL + "/rest.cgi/user?api_key=" + this.BUGZILLAKEY + "&throwExceptionOnFailure=true")).to("stream:out");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(this.EVENT_INDIVIDUAL_CREATE).unmarshal().json(JsonLibrary.Jackson, IndividualCreateEvent.class, true).bean(BugzillaClient.class, "transformIndividual2BugzillaUser")).marshal().json(JsonLibrary.Jackson, true).convertBodyTo(String.class)).to("stream:out")).setHeader("CamelHttpMethod", (Expression)this.constant((Object)HttpMethods.POST))).toD((String)usedBUGZILLAURL + "/rest.cgi/user?api_key=" + this.BUGZILLAKEY + "&throwExceptionOnFailure=true")).to("stream:out");
        ((ProcessorDefinition)this.from("direct:dlq_users").setBody().body(String.class)).to("stream:out");
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:bugzilla.bugmanage").choice().when(this.issueExists).log("Update ISSUE for ${body.alias} !")).process(this.BugHeaderExtractProcessor)).to("direct:bugzilla.updateIssue")).endChoice().otherwise().log("New ISSUE for ${body.alias} !")).to("direct:bugzilla.newIssue")).endChoice();
        ((RouteDefinition)this.from(this.EVENT_SERVICE_ORDER_CREATE).unmarshal().json(JsonLibrary.Jackson, ServiceOrderCreateNotification.class, true).bean(BugzillaClient.class, "transformNotification2BugBody")).to("direct:bugzilla.newIssue");
        ((RouteDefinition)this.from(this.EVENT_SERVICE_ORDER_ATTRIBUTE_VALUE_CHANGED).unmarshal().json(JsonLibrary.Jackson, ServiceOrderAttributeValueChangeNotification.class, true).bean(BugzillaClient.class, "transformNotification2BugBody")).to("direct:bugzilla.bugmanage");
        ((RouteDefinition)this.from(this.EVENT_SERVICE_ORDER_DELETE).unmarshal().json(JsonLibrary.Jackson, ServiceOrderDeleteNotification.class, true).bean(BugzillaClient.class, "transformNotification2BugBody")).to("direct:bugzilla.bugmanage");
        ((RouteDefinition)this.from(this.EVENT_SERVICE_ORDER_STATE_CHANGED).unmarshal().json(JsonLibrary.Jackson, ServiceOrderStateChangeNotification.class, true).bean(BugzillaClient.class, "transformNotification2BugBody")).to("direct:bugzilla.bugmanage");
        ((RouteDefinition)this.from("activemq:topic:vxf.validationresult.update").unmarshal().json(JsonLibrary.Jackson, ValidationStatus.class, true).bean(BugzillaClient.class, "transformVxFValidation2BugBody")).to("direct:bugzilla.bugmanage");
        ((RouteDefinition)this.from("activemq:topic:vxf.onboard").unmarshal().json(JsonLibrary.Jackson, VxFOnBoardedDescriptor.class, true).bean(BugzillaClient.class, "transformVxFAutomaticOnBoarding2BugBody")).to("direct:bugzilla.newIssue");
        ((RouteDefinition)this.from("activemq:topic:vxf.onBoardByCompositeObj").unmarshal().json(JsonLibrary.Jackson, CompositeVxFOnBoardDescriptor.class, true).bean(BugzillaClient.class, "transformVxFAutomaticOnBoarding2BugBodyCompObj")).to("direct:bugzilla.newIssue");
        ((RouteDefinition)this.from("activemq:topic:vxf.offboard").unmarshal().json(JsonLibrary.Jackson, VxFOnBoardedDescriptor.class, true).bean(BugzillaClient.class, "transformVxFAutomaticOffBoarding2BugBody")).to("direct:bugzilla.bugmanage");
        ((ExpressionNode)((ExpressionNode)this.from("activemq:topic:vxf.onboard.success").unmarshal().json(JsonLibrary.Jackson, VxFOnBoardedDescriptor.class, true).delay(30000L).bean(BugzillaClient.class, "transformVxFAutomaticOnBoarding2BugBody")).process(this.BugHeaderExtractProcessor)).to("direct:bugzilla.updateIssue");
        ((ExpressionNode)((ExpressionNode)this.from("activemq:topic:vxf.onboard.fail").unmarshal().json(JsonLibrary.Jackson, VxFOnBoardedDescriptor.class, true).delay(30000L).bean(BugzillaClient.class, "transformVxFAutomaticOnBoarding2BugBody")).process(this.BugHeaderExtractProcessor)).to("direct:bugzilla.updateIssue");
        ((RouteDefinition)this.from("activemq:topic:nsd.onboard").unmarshal().json(JsonLibrary.Jackson, ExperimentOnBoardDescriptor.class, true).bean(BugzillaClient.class, "transformNSDAutomaticOnBoarding2BugBody")).to("direct:bugzilla.newIssue");
        ((RouteDefinition)((RouteDefinition)this.from("activemq:topic:nsd.onBoardByCompositeObj").log("activemq:topic:nsd.onBoardByCompositeObj for ${body} !")).unmarshal().json(JsonLibrary.Jackson, CompositeExperimentOnBoardDescriptor.class, true).bean(BugzillaClient.class, "transformNSDAutomaticOnBoarding2BugBodyCompObj")).to("direct:bugzilla.newIssue");
        ((RouteDefinition)this.from("activemq:topic:nsd.offboard").unmarshal().json(JsonLibrary.Jackson, ExperimentOnBoardDescriptor.class, true).bean(BugzillaClient.class, "transformNSDAutomaticOffBoarding2BugBody")).to("direct:bugzilla.bugmanage");
        ((ExpressionNode)((ExpressionNode)this.from("activemq:topic:nsd.onboard.success").unmarshal().json(JsonLibrary.Jackson, ExperimentOnBoardDescriptor.class, true).delay(30000L).bean(BugzillaClient.class, "transformNSDAutomaticOnBoarding2BugBody")).process(this.BugHeaderExtractProcessor)).to("direct:bugzilla.updateIssue");
        ((ExpressionNode)((ExpressionNode)this.from("activemq:topic:nsd.onboard.fail").unmarshal().json(JsonLibrary.Jackson, ExperimentOnBoardDescriptor.class, true).delay(30000L).bean(BugzillaClient.class, "transformNSDAutomaticOnBoarding2BugBody")).process(this.BugHeaderExtractProcessor)).to("direct:bugzilla.updateIssue");
        ((ExpressionNode)this.from("activemq:topic:nsd.deployment.instantiation.success").unmarshal().json(JsonLibrary.Jackson, DeploymentDescriptor.class, true).delay(30000L).bean(BugzillaClient.class, "transformNSInstantiation2BugBody")).to("direct:bugzilla.bugmanage");
        ((ExpressionNode)this.from("activemq:topic:nsd.deployment.termination.success").unmarshal().json(JsonLibrary.Jackson, DeploymentDescriptor.class, true).delay(30000L).bean(BugzillaClient.class, "transformNSInstantiation2BugBody")).to("direct:bugzilla.bugmanage");
        ((ExpressionNode)this.from("activemq:topic:nsd.deployment.termination.fail").unmarshal().json(JsonLibrary.Jackson, DeploymentDescriptor.class, true).delay(30000L).bean(BugzillaClient.class, "transformNSInstantiation2BugBody")).to("direct:bugzilla.bugmanage");
        ((RouteDefinition)this.from("activemq:topic:deployments.create").unmarshal().json(JsonLibrary.Jackson, DeploymentDescriptor.class, true).bean(BugzillaClient.class, "transformDeployment2BugBody")).to("direct:bugzilla.newIssue");
        ((RouteDefinition)((RouteDefinition)this.from("activemq:topic:deployments.update").unmarshal().json(JsonLibrary.Jackson, DeploymentDescriptor.class, true).bean(BugzillaClient.class, "transformDeployment2BugBody")).process(this.BugHeaderExtractProcessor)).to("direct:bugzilla.updateIssue");
        ((ExpressionNode)this.from("activemq:topic:communication.osm.fail").delay(30000L).bean(BugzillaClient.class, "transformOSMCommunicationFail2BugBody")).to("direct:bugzilla.bugmanage");
        ((ExpressionNode)this.from("activemq:topic:communication.osm5.success").delay(30000L).bean(BugzillaClient.class, "transformOSMCommunicationSuccess2BugBody")).to("direct:bugzilla.bugmanage");
        ((ExpressionNode)this.from("activemq:topic:nsd.schedule").unmarshal().json(JsonLibrary.Jackson, DeploymentDescriptor.class, true).delay(30000L).bean(BugzillaClient.class, "transformNSInstantiation2BugBody")).to("direct:bugzilla.bugmanage");
        ((ExpressionNode)this.from("activemq:topic:nsd.deployment.instantiation.fail").unmarshal().json(JsonLibrary.Jackson, DeploymentDescriptor.class, true).delay(30000L).bean(BugzillaClient.class, "transformNSInstantiation2BugBody")).to("direct:bugzilla.bugmanage");
        ((ExpressionNode)this.from("activemq:topic:nsd.instance.termination.success").unmarshal().json(JsonLibrary.Jackson, DeploymentDescriptor.class, true).delay(30000L).bean(BugzillaClient.class, "transformNSTermination2BugBody")).to("direct:bugzilla.bugmanage");
        ((ExpressionNode)this.from("activemq:topic:nsd.instance.termination.fail").unmarshal().json(JsonLibrary.Jackson, DeploymentDescriptor.class, true).delay(30000L).bean(BugzillaClient.class, "transformNSTermination2BugBody")).to("direct:bugzilla.bugmanage");
        ((ExpressionNode)this.from("activemq:topic:nsd.instance.deletion.success").unmarshal().json(JsonLibrary.Jackson, DeploymentDescriptor.class, true).delay(30000L).bean(BugzillaClient.class, "transformNSDeletion2BugBody")).to("direct:bugzilla.bugmanage");
        ((ExpressionNode)this.from("activemq:topic:nsd.instance.deletion.fail").unmarshal().json(JsonLibrary.Jackson, DeploymentDescriptor.class, true).delay(30000L).bean(BugzillaClient.class, "transformNSDeletion2BugBody")).to("direct:bugzilla.bugmanage");
        ((ExpressionNode)this.from("activemq:topic:nsd.deployment.reject").unmarshal().json(JsonLibrary.Jackson, DeploymentDescriptor.class, true).delay(30000L).bean(BugzillaClient.class, "transformDeployment2BugBody")).to("direct:bugzilla.bugmanage");
        ((RouteDefinition)this.from("direct:issue.get").setHeader("CamelHttpMethod", (Expression)this.constant((Object)HttpMethods.GET))).toD((String)usedBUGZILLAURL + "/rest.cgi/bug/${header.uuid}?api_key=" + this.BUGZILLAKEY + "&throwExceptionOnFailure=true");
        ((ProcessorDefinition)this.from("direct:dlq_bugzilla").setBody().body(String.class)).to("stream:out");
    }
}

