/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.bugzilla;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.validation.Valid;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.etsi.osl.bugzilla.model.Bug;
import org.etsi.osl.bugzilla.model.Comment;
import org.etsi.osl.bugzilla.model.User;
import org.etsi.osl.model.nfv.CompositeExperimentOnBoardDescriptor;
import org.etsi.osl.model.nfv.CompositeVxFOnBoardDescriptor;
import org.etsi.osl.model.nfv.DeploymentDescriptor;
import org.etsi.osl.model.nfv.DeploymentDescriptorStatus;
import org.etsi.osl.model.nfv.DeploymentDescriptorVxFPlacement;
import org.etsi.osl.model.nfv.ExperimentMetadata;
import org.etsi.osl.model.nfv.ExperimentOnBoardDescriptor;
import org.etsi.osl.model.nfv.IMANOCommunicationStatus;
import org.etsi.osl.model.nfv.OnBoardingStatus;
import org.etsi.osl.model.nfv.PortalUser;
import org.etsi.osl.model.nfv.VFImage;
import org.etsi.osl.model.nfv.ValidationJob;
import org.etsi.osl.model.nfv.ValidationStatus;
import org.etsi.osl.model.nfv.VxFMetadata;
import org.etsi.osl.model.nfv.VxFOnBoardedDescriptor;
import org.etsi.osl.tmf.common.model.Notification;
import org.etsi.osl.tmf.common.model.service.Characteristic;
import org.etsi.osl.tmf.common.model.service.Note;
import org.etsi.osl.tmf.pm632.model.ContactMedium;
import org.etsi.osl.tmf.pm632.model.Individual;
import org.etsi.osl.tmf.pm632.model.IndividualCreateEvent;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.so641.model.ServiceOrder;
import org.etsi.osl.tmf.so641.model.ServiceOrderAttributeValueChangeNotification;
import org.etsi.osl.tmf.so641.model.ServiceOrderCreateNotification;
import org.etsi.osl.tmf.so641.model.ServiceOrderDeleteNotification;
import org.etsi.osl.tmf.so641.model.ServiceOrderItem;
import org.etsi.osl.tmf.so641.model.ServiceOrderStateChangeNotification;
import org.etsi.osl.tmf.so641.model.ServiceOrderStateType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public class BugzillaClient {
    private static final transient Log logger = LogFactory.getLog((String)BugzillaClient.class.getName());
    static CamelContext contxt;
    @Value(value="${portaltitle}")
    private String PORTAL_TITLE = "";
    @Value(value="${maindomain}")
    private String MAIN_CFS_URL;
    @Value(value="${main_operations_product}")
    private String MAIN_OPERATIONS_PRODUCT;
    private static final String BUGHEADER = "THIS IS AN AUTOMATED ISSUE CREATED BY OPENSLICE SERVICES.\n*********************************************************\n";

    @Autowired
    public void setActx(CamelContext actx) {
        contxt = actx;
        logger.info((Object)("BugzillaClient configure() contxt = " + String.valueOf(contxt)));
    }

    private VxFMetadata getVxFFromID(long vxfid) {
        ProducerTemplate template = contxt.createProducerTemplate();
        String ret = (String)template.requestBody("activemq:queue:getVxFByID", (Object)vxfid, String.class);
        try {
            ObjectMapper mapper = new ObjectMapper();
            VxFMetadata vxf = (VxFMetadata)mapper.readValue(ret, VxFMetadata.class);
            return vxf;
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private ExperimentMetadata getNSDFromID(long nsdid) {
        ProducerTemplate template = contxt.createProducerTemplate();
        String ret = (String)template.requestBody("activemq:queue:getNSDByID", (Object)nsdid, String.class);
        try {
            ObjectMapper mapper = new ObjectMapper();
            ExperimentMetadata nsd = (ExperimentMetadata)mapper.readValue(ret, ExperimentMetadata.class);
            return nsd;
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Comment createComment(String description) {
        Comment c = new Comment();
        c.setComment(description);
        c.setIs_markdown(Boolean.valueOf(false));
        c.setIs_private(Boolean.valueOf(false));
        return c;
    }

    public static User transformUser2BugzillaUser(PortalUser portalUser) {
        User u = new User();
        u.setEmail(portalUser.getEmail());
        u.setFullName(portalUser.getFirstname() + portalUser.getLastname());
        u.setPassword(UUID.randomUUID().toString());
        logger.info((Object)("In : portaluser getLastname = " + portalUser.getLastname()));
        return u;
    }

    public static User transformIndividual2BugzillaUser(IndividualCreateEvent individualCreateEvent) {
        @Valid Individual indv = individualCreateEvent.getEvent().getIndividual();
        User u = new User();
        for (ContactMedium cm : indv.getContactMedium()) {
            if (cm.getCharacteristic().getEmailAddress() == null) continue;
            u.setEmail(cm.getCharacteristic().getEmailAddress());
        }
        u.setFullName(indv.getFullName() + indv.getFamilyName());
        u.setPassword(UUID.randomUUID().toString());
        logger.info((Object)("In : Individual getFamilyName = " + indv.getFamilyName() + " email: " + u.getEmail()));
        return u;
    }

    public Bug transformNSInstantiation2BugBody(DeploymentDescriptor descriptor) {
        String product = this.MAIN_OPERATIONS_PRODUCT;
        String component = "Operations Support";
        String summary = "[PORTAL] Deployment Request of NSD:" + descriptor.getExperiment().getName() + ",User: " + descriptor.getOwner().getUsername();
        String alias = descriptor.getUuid();
        String description = this.getDeploymentDescription(descriptor);
        String status = "CONFIRMED";
        String resolution = null;
        if (descriptor.getStatus() == DeploymentDescriptorStatus.TERMINATED || descriptor.getStatus() == DeploymentDescriptorStatus.COMPLETED || descriptor.getStatus() == DeploymentDescriptorStatus.RUNNING) {
            status = "RESOLVED";
            resolution = "FIXED";
        } else if (descriptor.getStatus() == DeploymentDescriptorStatus.REJECTED || descriptor.getStatus() == DeploymentDescriptorStatus.FAILED) {
            status = "RESOLVED";
            resolution = "INVALID";
        }
        Bug b = this.createBug(product, component, summary, alias, description, descriptor.getOwner().getEmail(), status, resolution);
        b.setAssignedTo(descriptor.getMentor().getEmail());
        return b;
    }

    public Bug transformNSTermination2BugBody(DeploymentDescriptor descriptor) {
        logger.debug((Object)("transformNSTermination2BugBody" + descriptor.toString()));
        String product = this.MAIN_OPERATIONS_PRODUCT;
        String component = "Operations Support";
        String summary = "[PORTAL] Deployment Request of NSD:" + descriptor.getExperiment().getName() + ",User: " + descriptor.getOwner().getUsername();
        String alias = descriptor.getUuid();
        String description = this.getDeploymentDescription(descriptor);
        String status = "CONFIRMED";
        String resolution = null;
        if (descriptor.getStatus() == DeploymentDescriptorStatus.COMPLETED) {
            status = "RESOLVED";
            resolution = "FIXED";
        } else if (descriptor.getStatus() == DeploymentDescriptorStatus.TERMINATION_FAILED || descriptor.getStatus() == DeploymentDescriptorStatus.FAILED) {
            status = "RESOLVED";
            resolution = "INVALID";
        }
        Bug b = this.createBug(product, component, summary, alias, description, descriptor.getOwner().getEmail(), status, resolution);
        return b;
    }

    public Bug transformNSDeletion2BugBody(DeploymentDescriptor descriptor) {
        String product = this.MAIN_OPERATIONS_PRODUCT;
        String component = "Operations Support";
        String summary = "[PORTAL] Deployment Request of NSD:" + descriptor.getExperiment().getName() + ",User: " + descriptor.getOwner().getUsername();
        String alias = descriptor.getUuid();
        String description = this.getDeploymentDescription(descriptor);
        String status = "CONFIRMED";
        String resolution = null;
        if (descriptor.getStatus() == DeploymentDescriptorStatus.COMPLETED || descriptor.getStatus() == DeploymentDescriptorStatus.FAILED_OSM_REMOVED) {
            status = "RESOLVED";
            resolution = "FIXED";
        } else if (descriptor.getStatus() == DeploymentDescriptorStatus.DELETION_FAILED) {
            status = "RESOLVED";
            resolution = "INVALID";
        }
        Bug b = this.createBug(product, component, summary, alias, description, descriptor.getOwner().getEmail(), status, resolution);
        return b;
    }

    public Bug transformDeployment2BugBody(DeploymentDescriptor descriptor) {
        logger.debug((Object)("transformDeployment2BugBody" + descriptor.toString()));
        String product = this.MAIN_OPERATIONS_PRODUCT;
        String component = "Operations Support";
        String summary = "[PORTAL] Deployment Request of NSD:" + descriptor.getExperiment().getName() + ",User: " + descriptor.getOwner().getUsername();
        String alias = descriptor.getUuid();
        String description = this.getDeploymentDescription(descriptor);
        String status = "CONFIRMED";
        String resolution = null;
        if (descriptor.getStatus() == DeploymentDescriptorStatus.SCHEDULED || descriptor.getStatus() == DeploymentDescriptorStatus.INSTANTIATING || descriptor.getStatus() == DeploymentDescriptorStatus.RUNNING) {
            status = "IN_PROGRESS";
            component = "NSD Deployment Request";
        } else if (descriptor.getStatus() == DeploymentDescriptorStatus.COMPLETED) {
            status = "RESOLVED";
            resolution = "FIXED";
        } else if (descriptor.getStatus() == DeploymentDescriptorStatus.REJECTED || descriptor.getStatus() == DeploymentDescriptorStatus.FAILED) {
            status = "RESOLVED";
            resolution = "INVALID";
        }
        Bug b = this.createBug(product, component, summary, alias, description, descriptor.getOwner().getEmail(), status, resolution);
        if (descriptor.getMentor() != null) {
            b.setAssignedTo(descriptor.getMentor().getEmail());
        }
        return b;
    }

    public Comment transformDeployment2BugComment(DeploymentDescriptor descriptor) {
        String description = this.getDeploymentDescription(descriptor);
        Comment b = BugzillaClient.createComment((String)description);
        return b;
    }

    private String getDeploymentDescription(DeploymentDescriptor descriptor) {
        StringBuilder description = new StringBuilder("THIS IS AN AUTOMATED ISSUE CREATED BY OPENSLICE SERVICES.\n*********************************************************\n");
        description.append("\nSTATUS: " + String.valueOf(descriptor.getStatus()) + "\n");
        if (descriptor.getStartDate() != null) {
            description.append("\nFeedback: " + descriptor.getFeedback());
            description.append("\nScheduled Start Date: " + descriptor.getStartDate().toString());
            description.append("\nScheduled End Date: " + descriptor.getEndDate().toString());
        } else {
            description.append("\nNOT YET SCHEDULED \n");
        }
        description.append("\nDeployment Request by user :" + descriptor.getOwner().getUsername() + "\nHere are the details:\n\nExperiment name: " + descriptor.getName() + "\nDescription: " + descriptor.getDescription() + "\nDate Created: " + descriptor.getDateCreated().toString() + "\nRequested Tentative Start date: " + descriptor.getStartReqDate().toString() + "\nRequested Tentative End date: " + descriptor.getEndReqDate().toString() + "\nExperiment (NSD) requested: " + descriptor.getExperiment().getName());
        if (descriptor.getMentor() != null) {
            description.append("\nMentor: " + descriptor.getMentor().getFirstname() + " " + descriptor.getMentor().getLastname() + ", " + descriptor.getMentor().getOrganization());
        }
        description.append("\nConstituent VxF Placement ");
        for (DeploymentDescriptorVxFPlacement pl : descriptor.getVxfPlacements()) {
            if (pl.getConstituentVxF().getVxfref() == null || pl.getInfrastructure() == null) continue;
            description.append("\n  Constituent VxF: " + pl.getConstituentVxF().getVxfref().getName() + " - Infrastructure: " + pl.getInfrastructure().getName());
        }
        description.append("\n*************************************************\n");
        description.append("\nTo manage this Request, go to: " + this.MAIN_CFS_URL + "/#!/edit_deployment/" + descriptor.getId());
        return description.toString();
    }

    public Bug createBug(String product, String component, String summary, String alias, String description, String ccemail, String status, String resolution) {
        Bug b = new Bug();
        b.setProduct(product);
        b.setComponent(component);
        b.setSummary(summary);
        b.setVersion("unspecified");
        ArrayList<String> aliaslist = new ArrayList<String>();
        aliaslist.add(alias);
        b.setAlias(aliaslist);
        ArrayList<String> cclist = new ArrayList<String>();
        cclist.add(ccemail);
        b.setCc(cclist);
        b.setDescription(description.toString());
        b.setStatus(status);
        b.setResolution(resolution);
        return b;
    }

    public Bug transformVxFValidation2BugBody(VxFMetadata vxf) {
        logger.info((Object)("In transformVxFValidation2BugBody: alias = " + vxf.getUuid()));
        String product = this.MAIN_OPERATIONS_PRODUCT;
        String component = "Validation";
        String summary = "[PORTAL] Validation Request for VxF:" + vxf.getName() + ", Owner: " + vxf.getOwner().getUsername();
        String alias = vxf.getUuid();
        StringBuilder description = new StringBuilder("THIS IS AN AUTOMATED ISSUE CREATED BY OPENSLICE SERVICES.\n*********************************************************\n");
        description.append("\n\n VxF: " + vxf.getName());
        description.append("\n Owner: " + vxf.getOwner().getUsername());
        description.append("\n Vendor: " + vxf.getVendor());
        description.append("\n Version: " + vxf.getVersion());
        description.append("\n Archive: " + vxf.getPackageLocation());
        description.append("\n UUID: " + vxf.getUuid());
        description.append("\n ID: " + vxf.getId());
        description.append("\n Date Created: " + vxf.getDateCreated().toString());
        description.append("\n Date Updated: " + vxf.getDateUpdated().toString());
        description.append("\n VDU Images: ");
        for (VFImage img : vxf.getVfimagesVDU()) {
            description.append("\n\t Image: " + img.getName() + ", " + this.MAIN_CFS_URL + "/#!/vfimage_view/" + img.getId());
        }
        description.append("\n");
        description.append("\n Validation Status: " + String.valueOf(vxf.getValidationStatus()));
        description.append("\n Validation jobs: ");
        for (ValidationJob j : vxf.getValidationJobs()) {
            description.append("\n\t" + j.getDateCreated().toString() + ", id:" + j.getJobid() + ", Status:" + j.getValidationStatus() + ", Output:" + j.getOutputLog());
        }
        description.append("\n\n*************************************************\n");
        description.append("\nTo manage this , go to: " + this.MAIN_CFS_URL + "/#!/vxf_edit/" + vxf.getId());
        String status = "CONFIRMED";
        String resolution = null;
        if (vxf.getValidationStatus().equals((Object)ValidationStatus.UNDER_REVIEW)) {
            status = "CONFIRMED";
        } else if (vxf.getValidationStatus().equals((Object)ValidationStatus.COMPLETED)) {
            status = "RESOLVED";
            resolution = "FIXED";
        }
        Bug b = this.createBug(product, component, summary, alias, description.toString(), vxf.getOwner().getEmail(), status, resolution);
        return b;
    }

    public Bug transformVxFAutomaticOnBoarding2BugBodyCompObj(CompositeVxFOnBoardDescriptor compvxfobd) {
        return this.transformVxFAutomaticOnBoarding2BugBody(compvxfobd.getObd());
    }

    public Bug transformVxFAutomaticOnBoarding2BugBody(VxFOnBoardedDescriptor obd) {
        VxFOnBoardedDescriptor vxfobd = obd;
        logger.info((Object)("In transformVxFAutomaticOnBoarding2BugBody: alias = " + vxfobd.getUuid()));
        VxFMetadata avxf = this.getVxFFromID(vxfobd.getVxfid());
        if (avxf == null) {
            logger.error((Object)("Cannot retrieve VxF for vxf ID = " + vxfobd.getVxfid()));
            return null;
        }
        vxfobd.setVxf(avxf);
        String product = this.MAIN_OPERATIONS_PRODUCT;
        String component = "Onboarding";
        String summary = "[PORTAL] OSM OnBoarding Action for VxF:" + vxfobd.getVxf().getName() + ", Owner: " + vxfobd.getVxf().getOwner().getUsername();
        String alias = vxfobd.getUuid();
        StringBuilder description = new StringBuilder("**************************************************************\nTHIS IS AN AUTOMATED ISSUE UPDATE CREATED BY PORTAL API.\n**************************************************************\n VxF OSM ONBOARDING ACTION \n**************************************************************\n");
        description.append("\n\n VxF: " + vxfobd.getVxf().getName());
        description.append("\n Owner: " + vxfobd.getVxf().getOwner().getUsername());
        description.append("\n Vendor: " + vxfobd.getVxf().getVendor());
        description.append("\n Version: " + vxfobd.getVxf().getVersion());
        description.append("\n Archive: " + vxfobd.getVxf().getPackageLocation());
        description.append("\n UUID: " + vxfobd.getVxf().getUuid());
        description.append("\n ID: " + vxfobd.getVxf().getId());
        description.append("\n Date Created: " + vxfobd.getVxf().getDateCreated().toString());
        description.append("\n Date Updated: " + vxfobd.getVxf().getDateUpdated().toString());
        description.append("\n");
        description.append("\n VxF OnBoarding Status: " + String.valueOf(vxfobd.getOnBoardingStatus()));
        description.append("\n VxF OnBoarding Feedback: " + vxfobd.getFeedbackMessage());
        description.append("\n Last Onboarding: " + String.valueOf(vxfobd.getLastOnboarding()));
        description.append("\n Last Onboarding Deploy ID: " + vxfobd.getDeployId());
        description.append("\n Onboarding MANO provider: " + vxfobd.getObMANOprovider().getName());
        description.append("\n\n*************************************************\n");
        description.append("\nTo manage this , go to: " + this.MAIN_CFS_URL + "/#!/vxf_edit/" + vxfobd.getVxf().getId());
        String status = "CONFIRMED";
        String resolution = null;
        if (vxfobd.getOnBoardingStatus().equals((Object)OnBoardingStatus.ONBOARDED)) {
            status = "RESOLVED";
            resolution = "FIXED";
        } else if (vxfobd.getOnBoardingStatus().equals((Object)OnBoardingStatus.FAILED)) {
            status = "RESOLVED";
            resolution = "INVALID";
        }
        Bug b = this.createBug(product, component, summary, alias, description.toString(), vxfobd.getVxf().getOwner().getEmail(), status, resolution);
        return b;
    }

    public Bug transformNSDValidation2BugBody(ExperimentMetadata nsd) {
        logger.info((Object)("In transformNSDValidation2BugBody: alias = " + nsd.getUuid()));
        String product = this.MAIN_OPERATIONS_PRODUCT;
        String component = "Validation";
        String summary = "[PORTAL] Validation Request for NSD:" + nsd.getName() + ", Owner: " + nsd.getOwner().getUsername();
        String alias = nsd.getUuid();
        StringBuilder description = new StringBuilder("THIS IS AN AUTOMATED ISSUE CREATED BY OPENSLICE SERVICES.\n*********************************************************\n");
        description.append("\n Validation Status: " + String.valueOf(nsd.getValidationStatus()));
        description.append("\n Valid: " + String.valueOf(nsd.isValid()).toUpperCase());
        description.append("\n\n NSD: " + nsd.getName());
        description.append("\n Owner: " + nsd.getOwner().getUsername());
        description.append("\n Vendor: " + nsd.getVendor());
        description.append("\n Version: " + nsd.getVersion());
        description.append("\n Archive: " + nsd.getPackageLocation());
        description.append("\n UUID: " + nsd.getUuid());
        description.append("\n ID: " + nsd.getId());
        description.append("\n Date Created: " + nsd.getDateCreated().toString());
        description.append("\n Date Updated: " + nsd.getDateUpdated().toString());
        description.append("\n\n*************************************************\n");
        description.append("\nTo manage this , go to: " + this.MAIN_CFS_URL + "/#!/experiment_edit/" + nsd.getId());
        String status = "CONFIRMED";
        String resolution = null;
        if (nsd.getValidationStatus().equals((Object)ValidationStatus.UNDER_REVIEW)) {
            status = "IN_PROGRESS";
        } else if (nsd.isValid() && nsd.getValidationStatus().equals((Object)ValidationStatus.COMPLETED)) {
            status = "RESOLVED";
            resolution = "FIXED";
        } else if (!nsd.isValid() && nsd.getValidationStatus().equals((Object)ValidationStatus.COMPLETED)) {
            status = "RESOLVED";
            resolution = "INVALID";
        }
        Bug b = this.createBug(product, component, summary, alias, description.toString(), nsd.getOwner().getEmail(), status, resolution);
        return b;
    }

    public Bug transformNSDAutomaticOnBoarding2BugBodyCompObj(CompositeExperimentOnBoardDescriptor compoexpobd) {
        return this.transformNSDAutomaticOnBoarding2BugBody(compoexpobd.getObd());
    }

    public Bug transformNSDAutomaticOnBoarding2BugBody(ExperimentOnBoardDescriptor obd) {
        ExperimentOnBoardDescriptor uexpobd = obd;
        logger.info((Object)("In transformNSDAutomaticOnBoarding2BugBody: alias = " + uexpobd.getUuid()));
        ExperimentMetadata ansd = this.getNSDFromID(uexpobd.getExperimentid());
        if (ansd == null) {
            logger.error((Object)("Cannot retrieve NSD for vxf ID = " + uexpobd.getExperimentid()));
            return null;
        }
        uexpobd.setExperiment(ansd);
        String product = this.MAIN_OPERATIONS_PRODUCT;
        String component = "Onboarding";
        String summary = "[PORTAL] OSM OnBoarding Action for NSD:" + uexpobd.getExperiment().getName() + ", Owner: " + uexpobd.getExperiment().getOwner().getUsername();
        String alias = uexpobd.getUuid();
        StringBuilder description = new StringBuilder("**************************************************************\nTHIS IS AN AUTOMATED ISSUE UPDATE CREATED BY PORTAL API.\n**************************************************************\n NSD OSM ONBOARDING ACTION \n**************************************************************\n");
        description.append("\n\n NSD: " + uexpobd.getExperiment().getName());
        description.append("\n Owner: " + uexpobd.getExperiment().getOwner().getUsername());
        description.append("\n Vendor: " + uexpobd.getExperiment().getVendor());
        description.append("\n Version: " + uexpobd.getExperiment().getVersion());
        description.append("\n Archive: " + uexpobd.getExperiment().getPackageLocation());
        description.append("\n UUID: " + uexpobd.getExperiment().getUuid());
        description.append("\n ID: " + uexpobd.getExperiment().getId());
        description.append("\n Date Created: " + uexpobd.getExperiment().getDateCreated().toString());
        description.append("\n Date Updated: " + uexpobd.getExperiment().getDateUpdated().toString());
        description.append("\n");
        description.append("\n NSD OnBoarding Status: " + String.valueOf(uexpobd.getOnBoardingStatus()));
        description.append("\n NSD OnBoarding Feedback: " + uexpobd.getFeedbackMessage());
        description.append("\n Last Onboarding: " + String.valueOf(uexpobd.getLastOnboarding()));
        description.append("\n Last Onboarding Deploy ID: " + uexpobd.getDeployId());
        description.append("\n Onboarding MANO provider: " + uexpobd.getObMANOprovider().getName());
        description.append("\n\n*************************************************\n");
        description.append("\nTo manage this , go to: " + this.MAIN_CFS_URL + "/#!/experiment_edit/" + uexpobd.getExperiment().getId());
        String status = "CONFIRMED";
        String resolution = null;
        if (uexpobd.getOnBoardingStatus().equals((Object)OnBoardingStatus.ONBOARDED)) {
            status = "RESOLVED";
            resolution = "FIXED";
        } else if (uexpobd.getOnBoardingStatus().equals((Object)OnBoardingStatus.FAILED)) {
            status = "RESOLVED";
            resolution = "INVALID";
        }
        Bug b = this.createBug(product, component, summary, alias, description.toString(), uexpobd.getExperiment().getOwner().getEmail(), status, resolution);
        return b;
    }

    public Bug transformVxFAutomaticOffBoarding2BugBody(VxFOnBoardedDescriptor obd) {
        VxFOnBoardedDescriptor vxfobd = obd;
        logger.info((Object)("In transformVxFAutomaticOnBoarding2BugBody: alias = " + vxfobd.getUuid()));
        VxFMetadata avxf = this.getVxFFromID(vxfobd.getVxfid());
        if (avxf == null) {
            logger.error((Object)("Cannot retrieve VxF for vxf ID = " + vxfobd.getVxfid()));
            return null;
        }
        vxfobd.setVxf(avxf);
        String product = this.MAIN_OPERATIONS_PRODUCT;
        String component = "Offboarding";
        String summary = "[PORTAL] OSM OffBoarding Action for VxF:" + vxfobd.getVxf().getName() + ", Owner: " + vxfobd.getVxf().getOwner().getUsername();
        String alias = vxfobd.getUuid();
        StringBuilder description = new StringBuilder("**************************************************************\nTHIS IS AN AUTOMATED ISSUE UPDATE CREATED BY PORTAL API.\n**************************************************************\n VxF OSM OFFBOARDING ACTION \n**************************************************************\n");
        description.append("\n\n VxF: " + vxfobd.getVxf().getName());
        description.append("\n Owner: " + vxfobd.getVxf().getOwner().getUsername());
        description.append("\n Vendor: " + vxfobd.getVxf().getVendor());
        description.append("\n Version: " + vxfobd.getVxf().getVersion());
        description.append("\n Archive: " + vxfobd.getVxf().getPackageLocation());
        description.append("\n UUID: " + vxfobd.getVxf().getUuid());
        description.append("\n ID: " + vxfobd.getVxf().getId());
        description.append("\n Date Created: " + vxfobd.getVxf().getDateCreated().toString());
        description.append("\n Date Updated: " + vxfobd.getVxf().getDateUpdated().toString());
        description.append("\n");
        description.append("\n VxF OffBoarding Status: " + String.valueOf(vxfobd.getOnBoardingStatus()));
        description.append("\n VxF OffBoarding Feedback: " + vxfobd.getFeedbackMessage());
        description.append("\n\n*************************************************\n");
        description.append("\nTo manage this , go to: " + this.MAIN_CFS_URL + "/#!/vxf_edit/" + vxfobd.getVxf().getId());
        String status = "CONFIRMED";
        String resolution = null;
        if (vxfobd.getOnBoardingStatus().equals((Object)OnBoardingStatus.OFFBOARDED)) {
            status = "RESOLVED";
            resolution = "FIXED";
        } else if (vxfobd.getOnBoardingStatus().equals((Object)OnBoardingStatus.FAILED)) {
            status = "CONFIRMED";
        }
        Bug b = this.createBug(product, component, summary, alias, description.toString(), vxfobd.getVxf().getOwner().getEmail(), status, resolution);
        return b;
    }

    public Bug transformNSDAutomaticOffBoarding2BugBody(ExperimentOnBoardDescriptor obd) {
        ExperimentOnBoardDescriptor uexpobd = obd;
        ExperimentMetadata ansd = this.getNSDFromID(uexpobd.getExperimentid());
        if (ansd == null) {
            logger.error((Object)("Cannot retrieve NSD for vxf ID = " + uexpobd.getExperimentid()));
            return null;
        }
        uexpobd.setExperiment(ansd);
        String product = this.MAIN_OPERATIONS_PRODUCT;
        String component = "Offboarding";
        String summary = "[PORTAL] OSM OffBoarding Action for NSD:" + uexpobd.getExperiment().getName() + ", Owner: " + uexpobd.getExperiment().getOwner().getUsername();
        String alias = uexpobd.getUuid();
        StringBuilder description = new StringBuilder("**************************************************************\nTHIS IS AN AUTOMATED ISSUE UPDATE CREATED BY PORTAL API.\n**************************************************************\n NSD OSM OFFBOARDING ACTION \n**************************************************************\n");
        description.append("\n\n NSD: " + uexpobd.getExperiment().getName());
        description.append("\n Owner: " + uexpobd.getExperiment().getOwner().getUsername());
        description.append("\n Vendor: " + uexpobd.getExperiment().getVendor());
        description.append("\n Version: " + uexpobd.getExperiment().getVersion());
        description.append("\n Archive: " + uexpobd.getExperiment().getPackageLocation());
        description.append("\n UUID: " + uexpobd.getExperiment().getUuid());
        description.append("\n ID: " + uexpobd.getExperiment().getId());
        description.append("\n Date Created: " + uexpobd.getExperiment().getDateCreated().toString());
        description.append("\n Date Updated: " + uexpobd.getExperiment().getDateUpdated().toString());
        description.append("\n");
        description.append("\n NSD OffBoarding Status: " + String.valueOf(uexpobd.getOnBoardingStatus()));
        description.append("\n NSD OffBoarding Feedback: " + uexpobd.getFeedbackMessage());
        description.append("\n\n*************************************************\n");
        description.append("\nTo manage this , go to: " + this.MAIN_CFS_URL + "/#!/experiment_edit/" + uexpobd.getExperiment().getId());
        String status = "CONFIRMED";
        String resolution = null;
        if (uexpobd.getOnBoardingStatus().equals((Object)OnBoardingStatus.OFFBOARDED)) {
            status = "RESOLVED";
            resolution = "FIXED";
        } else if (uexpobd.getOnBoardingStatus().equals((Object)OnBoardingStatus.FAILED)) {
            status = "RESOLVED";
            resolution = "INVALID";
        }
        Bug b = this.createBug(product, component, summary, alias, description.toString(), uexpobd.getExperiment().getOwner().getEmail(), status, resolution);
        return b;
    }

    public Bug transformOSMCommunicationFail2BugBody() {
        String product = this.MAIN_OPERATIONS_PRODUCT;
        String component = "Operations Support";
        String summary = "[PORTAL] OSM Communication Action";
        StringBuilder description = new StringBuilder("**************************************************************\nTHIS IS AN AUTOMATED ISSUE UPDATE CREATED BY PORTAL API.\n**************************************************************\n OSM COMMUNICATION ACTION FAILURE\n**************************************************************\n");
        description.append("\n\n " + IMANOCommunicationStatus.getMessage());
        String status = "CONFIRMED";
        String resolution = null;
        Bug b = this.createBug(product, component, summary, IMANOCommunicationStatus.getOsmCommunicationStatusUUID(), description.toString(), null, status, resolution);
        return b;
    }

    public Bug transformOSMCommunicationSuccess2BugBody() {
        String product = this.MAIN_OPERATIONS_PRODUCT;
        String component = "Operations Support";
        String summary = "[PORTAL] OSM Communication Action";
        StringBuilder description = new StringBuilder("**************************************************************\nTHIS IS AN AUTOMATED ISSUE UPDATE CREATED BY PORTAL API.\n**************************************************************\n OSM COMMUNICATION ACTION RESTORED\n**************************************************************\n");
        description.append("\n\n " + IMANOCommunicationStatus.getMessage());
        String status = "RESOLVED";
        String resolution = "FIXED";
        Bug b = this.createBug(product, component, summary, IMANOCommunicationStatus.getOsmCommunicationStatusUUID(), description.toString(), null, status, resolution);
        return b;
    }

    public Bug transformNotification2BugBody(Notification n) {
        logger.debug((Object)("transformNotification2BugBody" + n.toString()));
        ServiceOrder so = null;
        String status = "CONFIRMED";
        if (n instanceof ServiceOrderCreateNotification) {
            so = ((ServiceOrderCreateNotification)n).getEvent().getServiceOrder();
            logger.debug((Object)("ServiceOrder=" + so.toString()));
        } else if (n instanceof ServiceOrderStateChangeNotification) {
            so = ((ServiceOrderStateChangeNotification)n).getEvent().getServiceOrder();
            logger.debug((Object)("ServiceOrder=" + so.toString()));
        } else if (n instanceof ServiceOrderAttributeValueChangeNotification) {
            so = ((ServiceOrderAttributeValueChangeNotification)n).getEvent().getServiceOrder();
            logger.debug((Object)("ServiceOrder=" + so.toString()));
        } else if (n instanceof ServiceOrderDeleteNotification) {
            so = ((ServiceOrderAttributeValueChangeNotification)n).getEvent().getServiceOrder();
            logger.debug((Object)("ServiceOrder=" + so.toString()));
        }
        if (so == null) {
            return null;
        }
        String alias = so.getUuid();
        String product = this.MAIN_OPERATIONS_PRODUCT;
        String component = "Operations Support";
        String summary = "[PORTAL] Service Order:" + alias;
        String description = this.getServiceOrderDescription(so);
        String resolution = null;
        if (so.getState().equals((Object)ServiceOrderStateType.INPROGRESS) || so.getState().equals((Object)ServiceOrderStateType.HELD) || so.getState().equals((Object)ServiceOrderStateType.PARTIAL) || so.getState().equals((Object)ServiceOrderStateType.PENDING)) {
            status = "IN_PROGRESS";
        } else if (so.getState().equals((Object)ServiceOrderStateType.COMPLETED)) {
            status = "RESOLVED";
            resolution = "FIXED";
        } else if (so.getState().equals((Object)ServiceOrderStateType.REJECTED) || so.getState().equals((Object)ServiceOrderStateType.FAILED)) {
            status = "RESOLVED";
            resolution = "INVALID";
        }
        RelatedParty rp = so.getOrderRequester();
        String email = "tranoris@ece.upatras.gr";
        if (rp.getExtendedInfo() != null) {
            email = rp.getExtendedInfo();
        }
        Bug b = this.createBug(product, component, summary, alias, description, email, status, resolution);
        return b;
    }

    private String getServiceOrderDescription(ServiceOrder so) {
        StringBuilder description = new StringBuilder("THIS IS AN AUTOMATED ISSUE CREATED BY OPENSLICE SERVICES.\n*********************************************************\n");
        description.append("\n Order id: " + so.getId());
        description.append("\n State: " + so.getState().name());
        description.append("\n Order Date: " + String.valueOf(so.getOrderDate()));
        description.append("\n Requested Start Date: " + so.getRequestedStartDateString());
        description.append("\n Requested Completion Date: " + so.getRequestedCompletionDateString());
        description.append("\n Start Date: " + so.getStartDateString());
        description.append("\n Expected Completion Date: " + so.getExpectedCompletionDateString());
        description.append("\n Parties:");
        for (RelatedParty rp : so.getRelatedParty()) {
            description.append("\n - " + rp.getRole() + ", " + rp.getName() + ", " + rp.getExtendedInfo());
        }
        description.append("\n Notes:");
        List notes = so.getNote().stream().sorted(Comparator.comparing(Note::getDate, Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.toList());
        for (Note note : notes) {
            description.append("\n - " + note.getDateString() + " [" + note.getAuthor() + "]:");
            description.append("\n   " + note.getText());
        }
        description.append("\n ");
        description.append("\n Order Items:");
        for (ServiceOrderItem soi : so.getOrderItem()) {
            description.append("\n\t ************************************");
            description.append("\n\t Order Item: " + soi.getId());
            description.append("\n\t Action: " + String.valueOf(soi.getAction()));
            description.append("\n\t State: " + String.valueOf(soi.getState()));
            description.append("\n\t ** Service Details **");
            description.append("\n\t - Service Specification Name: ");
            description.append("\n\t   " + soi.getService().getServiceSpecification().getName());
            description.append("\n\t - Service Specification Version: " + soi.getService().getServiceSpecification().getVersion());
            description.append("\n\t - Service State: " + String.valueOf(soi.getService().getState()));
            description.append("\n\t - Service Name: " + soi.getService().getName());
            description.append("\n\t - Characteristics");
            for (Characteristic c : soi.getService().getServiceCharacteristic()) {
                description.append("\n\t\t - " + c.getName());
                description.append("\n\t\t   " + c.getValue().getValue() + " (" + c.getValue().getAlias() + ")");
            }
            description.append("\n\t - SupportingServices");
            for (Characteristic c : soi.getService().getSupportingService()) {
                description.append("\n\t\t - " + c.getName());
            }
        }
        description.append("\n*************************************************\n");
        description.append("\nTo manage this Request, go to: " + this.MAIN_CFS_URL + "/services/service_order/" + so.getId());
        return description.toString();
    }
}

