package org.etsi.osl.example.gc.api;

import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.etsi.osl.example.gc.api.config.CatalogClient;
import org.etsi.osl.tmf.common.model.EValueType;
import org.etsi.osl.tmf.ri639.model.Characteristic;
import org.etsi.osl.tmf.ri639.model.Resource;
import org.etsi.osl.tmf.ri639.model.ResourceCreate;
import org.etsi.osl.tmf.ri639.model.ResourceStatusType;
import org.etsi.osl.tmf.ri639.model.ResourceUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourceRepoService {

  private static final Logger logger = LoggerFactory.getLogger("org.etsi.osl.example.gc");

  @Autowired
  CatalogClient aCatalogClient;
  

  @Autowired
  SimpleResourceMapper simpleResourceMapper;
  
  public Resource createResource( Map<String, Object> headers, ResourceCreate resourceRequested) {
    
    String resourceid = "";
    
    if ( headers.get("org.etsi.osl.serviceId") !=null ) {
      
    }    
    if ( headers.get("org.etsi.osl.resourceId") !=null ) { //the resource to update back
        resourceid = (String) headers.get("org.etsi.osl.resourceId") ;
    }    
    if ( headers.get("org.etsi.osl.serviceOrderId") !=null ) {
      
    }  

    ResourceUpdate resourceUpdate = simpleResourceMapper.resourceCreateToResourceUpdate(resourceRequested);
    
    if (resourceRequested.getResourceSpecification().getName().equals( ResourceA.RESOURCE_NAME )) {
      resourceUpdate = ResourceA.resourceLogic(resourceUpdate, resourceid);
    } else  if (resourceRequested.getResourceSpecification().getName().equals( ResourceB.RESOURCE_NAME )) {
      resourceUpdate = ResourceB.resourceLogic(resourceUpdate, resourceid);
    } else {
      return null;
    }
   
    //send it to TMF API
    Resource res = aCatalogClient.updateResourceById( resourceid, resourceUpdate);
    
    return res;
  }
  
  public Resource updateResource( Map<String, Object> headers, ResourceUpdate r) {
    String resourceid = "";
    
    if ( headers.get("org.etsi.osl.serviceId") !=null ) {
      
    }    
    if ( headers.get("org.etsi.osl.resourceId") !=null ) { //the resource to update back
        resourceid = (String) headers.get("org.etsi.osl.resourceId") ;
    }    
    if ( headers.get("org.etsi.osl.serviceOrderId") !=null ) {
      
    }  

    ResourceUpdate resourceUpdate = r;
    if (r.getResourceSpecification().getName().equals( ResourceA.RESOURCE_NAME )) {
      resourceUpdate = ResourceA.resourceLogic(resourceUpdate, resourceid);
    } else  if (r.getResourceSpecification().getName().equals( ResourceB.RESOURCE_NAME )) {
      resourceUpdate = ResourceB.resourceLogic(resourceUpdate, resourceid);
    } else {
      return null;
    }
    

    Resource res = aCatalogClient.updateResourceById( resourceid, resourceUpdate);
    
    return res;
  }
  
  public Resource deleteResource( Map<String, Object> headers, ResourceUpdate r) {
String resourceid = "";
    
    if ( headers.get("org.etsi.osl.serviceId") !=null ) {
      
    }    
    if ( headers.get("org.etsi.osl.resourceId") !=null ) { //the resource to update back
        resourceid = (String) headers.get("org.etsi.osl.resourceId") ;
    }    
    if ( headers.get("org.etsi.osl.serviceOrderId") !=null ) {
      
    }  

    
    ResourceUpdate resourceUpdate = r;
    resourceUpdate.setResourceStatus(ResourceStatusType.UNKNOWN);
    
    resourceUpdate.addResourceCharacteristicItemShort("status.infoMessage", "all well deleted",  EValueType.TEXT.getValue());
    resourceUpdate.addResourceCharacteristicItemShort("status.Health", "Deleted " + new Date(),  EValueType.TEXT.getValue());
    
    Resource res = aCatalogClient.updateResourceById( resourceid, resourceUpdate);
    
    return res;
  }
  
  
  
  
  
}
