package org.etsi.osl.example.gc.api;

import java.net.URL;
import org.etsi.osl.example.gc.api.config.CatalogClient;
import org.etsi.osl.tmf.common.model.Any;
import org.etsi.osl.tmf.pm632.model.Characteristic;
import org.etsi.osl.tmf.pm632.model.Organization;
import org.etsi.osl.tmf.pm632.model.OrganizationAttributeValueChangeEvent;
import org.etsi.osl.tmf.rcm634.model.LogicalResourceSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRef;
import org.etsi.osl.tmf.ri639.model.Resource;
import org.etsi.osl.tmf.ri639.model.ResourceCreate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import jakarta.annotation.PreDestroy;
import lombok.Data;

/**
 * @author ctranoris
 */
@Service
public class BootstrapService {

	private static final Logger logger = LoggerFactory.getLogger("org.etsi.osl.example.gc");

	
	
    @Autowired
    CatalogClient catalogClient;
    
    @Value("${osl-controller.category}")
    private String compcategory;

    @Value("${osl-controller.version}")
    private String compversion;
    

	/**
	 * This one is executed when the cridge service application starts
	 * 
	 * It creates here a default model in OSL TMF
	 * Create any related Logical resource specifications
	 * 
	 * 
	 * @param event
	 * @throws Exception 
	 */
	@EventListener(ApplicationStartedEvent.class)
	public void onApplicationEvent() throws Exception {

	    
        ResourceA rspecFed = new ResourceA( compversion, compcategory);
        LogicalResourceSpecification lrs = catalogClient.createOrUpdateResourceSpecByNameCategoryVersion(rspecFed.toRSpecCreate_InitRepo());
        
        
        ResourceB rspecFed2 = new ResourceB( compversion, compcategory);
        LogicalResourceSpecification lrs2 = catalogClient.createOrUpdateResourceSpecByNameCategoryVersion(rspecFed2.toRSpecCreate_InitRepo());

	}






	@PreDestroy
	private void stop() {
		logger.info("Closing due to ContextStoppedEvent ");
	}
}
