# Generic Controller example

OSL's Service orchestrator (OSOM) has the capability of contacting external controllers, given a specific resource category that this controller can manage. 

This project is an example of creating a generic controller, that registers two Resource Specifications for managing resources ResourceA and ResourceB. 

Listens for messages on queues as registered by category name and version for CREATE/UPD/DELETE, with this scheme:

- CREATE / category_name / version
- UPDATE / category_name / version
- DELETE / category_name / version

here we have:

  - category: gcontroller.examples.osl.etsi.org
  - version: 0.1.0


The project registers automatically the two Resource Specifications (RSpecs) and we added handler functions for create, update and delete.

So when you create CFSs services using these (RSpecs) the Service Orchestrator will call these functions via the queue