/*-
 * ========================LICENSE_START=================================
 * org.etsi.osl.controllers.sylva
 * %%
 * Copyright (C) 2024 osl.etsi.org
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
package org.etsi.osl.controllers.sylva;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class KubernetesClientConfig {

  @Bean
  public KubernetesClient kubernetesClient() {
    // Create a custom configuration that disables SSL verification
    Config config = new ConfigBuilder()
        .withRequestTimeout(30000)  // 30 seconds
        .withConnectionTimeout(30000)  // 30 seconds
        .withWatchReconnectInterval(5000)  // Reconnect interval for watches
        .build(); 

    // Build the Kubernetes client with this configuration
    return new KubernetesClientBuilder().withConfig(config).build();
  }
}
