/*-
 * ========================LICENSE_START=================================
 * org.etsi.osl.controllers.sylva
 * %%
 * Copyright (C) 2024 osl.etsi.org
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
package org.etsi.osl.controllers.kcj;

import lombok.Data;

@Data
public class KCJResourceSpec {

  /**
   *provide kube config to connect to cluster
   */
  private String clusterConfig;
  /**
   *provide kube config as base64 string
   */
  private String clusterConfigBase64;
  /**
   *if true installs argo cd to remote cluster
   */
  private boolean installArgoCDRemote;
  /**
   *if true installs OSL CRIDGE in local cluster and configures it
   */
  private boolean installCridgeLocal;  
  /**
   *if true installs OSL CRIDGE in remote cluster and configures it
   */
  private boolean installCridgeRemote;  
  /**
   * Active MQ endpoint for CRIDGE to connect
   */
  private String cridgeAMQEndPoint;
  /**
   *Active MQ username for CRIDGE to connect
   */
  private String cridgeAMQUsername;
  /**
   *Active MQ password for CRIDGE to connect
   */
  private String cridgeAMQPassword;  
  /**
   * if true will  add the Kubernetes cluster to Argo CD using the CRD method.
   * Will create service account and add cluster to local argoCD 
   */
  private boolean addClusterToLocalArgoCD; 
  
}
