# org.etsi.osl.controllers.kcj

OSL Operator for configuring an external Kubernetes  Cluster to Join the OSL management cluster and enable it for deploying services and applications

## Getting started

`helm install oslkcj . --set-file  kubeconfig=../src/main/resources/config`


The operator is as follows:

```
apiVersion: controllers.osl.etsi.org/v1alpha1
kind: KCJResource
metadata:
  name: kcjexample
spec:
  clusterConfigBase64: \\kubeconfig of remote cluster in BASE64
  installArgoCDRemote: \\if true will install ARGO in remote cluster
  installCridgeLocal: \\if true will install CRDIGE in local OSL management cluster via local ARGO. This CRIDGE will monitor remotely the remote cluster
  installCridgeRemote: \\if true will install CRDIGE in remote cluster via remote or local ARGO. This CRIDGE will monitor the remote cluster and connect to OSL management cluster
  cridgeAMQEndPoint: "tcp://osl-url:61616?jms.watchTopicAdvisories=false" \\the URL of the OSL service bus 
  cridgeAMQUsername: "artemis" \\the username to connect to the OSL service bus
  cridgeAMQPassword: "artemis" \\the password to connect to the OSL service bus
  addClusterToLocalArgoCD: false \\ if true will create service account to remote cluster and add the cluster to local ARGO in OSL management cluster
```




## Examples


### Add remote kubernetes cluster to local Argo in OSL management cluster

```
apiVersion: controllers.osl.etsi.org/v1alpha1
kind: KCJResource
metadata:
  name: kcjexample
spec:
  clusterConfigBase64: "YXBpVmVyc2lv...vPQo="
  installArgoCDRemote: false
  installCridgeLocal: false
  installCridgeRemote: false
  cridgeAMQEndPoint: "tcp://osl-url:61616?jms.watchTopicAdvisories=false"
  cridgeAMQUsername: "artemis"
  cridgeAMQPassword: "artemis"
  addClusterToLocalArgoCD: true
```
  
### Install CRIDGE in OSL management cluster to manage remote cluster 

```
apiVersion: controllers.osl.etsi.org/v1alpha1
kind: KCJResource
metadata:
  name: kcjexample
spec:
  clusterConfigBase64: "YXBpVmVyc2lv...vPQo="
  installArgoCDRemote: false
  installCridgeLocal: true
  installCridgeRemote: false
  cridgeAMQEndPoint: "tcp://osl-url:61616?jms.watchTopicAdvisories=false"
  cridgeAMQUsername: "artemis"
  cridgeAMQPassword: "artemis"
  addClusterToLocalArgoCD: true
```


### Install ARGO to remote cluster and then install CRIDGE in remote cluster to manage remote cluster 

```
apiVersion: controllers.osl.etsi.org/v1alpha1
kind: KCJResource
metadata:
  name: kcjexample
spec:
  clusterConfigBase64: "YXBpVmVyc2lv...vPQo="
  installArgoCDRemote: true
  installCridgeLocal: false
  installCridgeRemote: true
  cridgeAMQEndPoint: "tcp://osl-url:61616?jms.watchTopicAdvisories=false"
  cridgeAMQUsername: "artemis"
  cridgeAMQPassword: "artemis"
  addClusterToLocalArgoCD: false
```








