package org.etsi.osl.controllers.capif.invoker;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import java.util.List;

@Configuration
@ConfigurationProperties(prefix = "capif")
public class SpringCapifInvokersConfig {

    private List<Invoker> invokers;

    public static class Invoker {
        private String name;
        private String privatekey;
        private String publickey;
        private String description; 
        private List<ApiName> apinames;

        public static class ApiName {
            private String api;

            public String getApi() {
                return api;
            }

            public void setApi(String api) {
                this.api = api;
            }
        }
        
        

        /**
         * @return the description
         */
        public String getDescription() {
          return description;
        }

        /**
         * @param description the description to set
         */
        public void setDescription(String description) {
          this.description = description;
        }

        // Getters and setters
        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPrivatekey() {
            return privatekey;
        }

        public void setPrivatekey(String privatekey) {
            this.privatekey = privatekey;
        }

        public String getPublickey() {
            return publickey;
        }

        public void setPublickey(String publickey) {
            this.publickey = publickey;
        }


        public List<ApiName> getApinames() {
            return apinames;
        }

        public void setApinames(List<ApiName> apinames) {
            this.apinames = apinames;
        }
    }

    public List<Invoker> getInvokers() {
        return invokers;
    }

    public void setInvokers(List<Invoker> invokers) {
        this.invokers = invokers;
    }
}
