package org.etsi.osl.controllers.capif.invoker;

import java.util.Date;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.ConcurrentHashMap;
import org.etsi.osl.tmf.common.model.EValueType;
import org.etsi.osl.tmf.ri639.model.Resource;
import org.etsi.osl.tmf.ri639.model.ResourceCreate;
import org.etsi.osl.tmf.ri639.model.ResourceStatusType;
import org.etsi.osl.tmf.ri639.model.ResourceUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ResourceRepoService {

  private static final Logger logger = LoggerFactory.getLogger("org.etsi.osl.controllers.capif.invoker");

  @Autowired
  CatalogClient aCatalogClient;

  @Autowired
  SimpleResourceMapper simpleResourceMapper;

  @Autowired
  InvokerManagement invokerManagement;
  
  @Value("${osl-controller.category}")
  private String compcategory;

  @Value("${osl-controller.version}")
  private String compversion;
  
  
  /**
   * keeps a map of which resources are using the equivalent Invoker
   */
  Map<String, CapifInvokerResource> resourceToInvokerMap = new ConcurrentHashMap<>();
  
  
  public Resource createResource( Map<String, Object> headers, ResourceCreate resourceRequested) {

    logger.info("In createResource");

    ResourceUpdate resourceUpdate = simpleResourceMapper.resourceCreateToResourceUpdate(resourceRequested);
    
    return updateResource(headers, resourceUpdate );
  }
  
  public Resource updateResource( Map<String, Object> headers, ResourceUpdate resourceUpdate) {
   String resourceid = "";
    
    if ( headers.get("org.etsi.osl.serviceId") !=null ) {
      
    }    
    if ( headers.get("org.etsi.osl.resourceId") !=null ) { //the resource to update back
        resourceid = (String) headers.get("org.etsi.osl.resourceId") ;
    }    
    if ( headers.get("org.etsi.osl.serviceOrderId") !=null ) {
      
    }  

    resourceUpdate.setResourceStatus(ResourceStatusType.UNKNOWN );

    logger.info("In updateResource " + resourceid);
    
    try {

      CapifInvoker onboardedInvoker = invokerManagement.onboardInvokerByName( resourceUpdate.getResourceSpecification().getName() );
      if ( onboardedInvoker != null ) {        
        
        CapifInvokerResource aCapifInvokerResource = new CapifInvokerResource( onboardedInvoker.getName(), compversion , 
            onboardedInvoker.getDescription() , compcategory, onboardedInvoker);


        resourceUpdate.addResourceCharacteristicItemShort("bearerAccessToken",  onboardedInvoker.getBearerAccessToken() , EValueType.TEXT.getValue());
        resourceUpdate.addResourceCharacteristicItemShort("status.discoveredServiceAPIs",  onboardedInvoker.getDiscoveredServiceAPIs()  , EValueType.TEXT.getValue());
        resourceUpdate.addResourceCharacteristicItemShort("status.state",  onboardedInvoker.getCapifInvokerState().name()  , EValueType.TEXT.getValue());
        resourceUpdate.addResourceCharacteristicItemShort("status.infoMessage",  "" , EValueType.TEXT.getValue());
        resourceUpdate.setResourceStatus(ResourceStatusType.AVAILABLE);

        resourceUpdate.addResourceCharacteristicItemShort("status.infoMessage", "onboarded to CAPIF service" ,  EValueType.TEXT.getValue());
        this.resourceToInvokerMap.put(resourceid, aCapifInvokerResource);
        
      }
      
    } catch (Exception e) {
      
      e.printStackTrace();

      resourceUpdate.addResourceCharacteristicItemShort("status.infoMessage", e.getLocalizedMessage() ,  EValueType.TEXT.getValue());
      resourceUpdate.addResourceCharacteristicItemShort("status.state", CapifInvokerState.ERROR.name() ,  EValueType.TEXT.getValue());
      resourceUpdate.setResourceStatus(ResourceStatusType.ALARM);
    }
   
    //send it to TMF API
    Resource res = aCatalogClient.updateResourceById( resourceid, resourceUpdate);
    
    return res;
  }
  
  public Resource deleteResource( Map<String, Object> headers, ResourceUpdate r) {
    String resourceid = "";
    
    if ( headers.get("org.etsi.osl.serviceId") !=null ) {
      
    }    
    if ( headers.get("org.etsi.osl.resourceId") !=null ) { //the resource to update back
        resourceid = (String) headers.get("org.etsi.osl.resourceId") ;
    }    
    if ( headers.get("org.etsi.osl.serviceOrderId") !=null ) {
      
    }  

    this.resourceToInvokerMap.remove(resourceid);
    
    ResourceUpdate resourceUpdate = r;
    resourceUpdate.setResourceStatus(ResourceStatusType.UNKNOWN);
    
    resourceUpdate.addResourceCharacteristicItemShort("status.infoMessage", "all well deleted",  EValueType.TEXT.getValue());
    resourceUpdate.addResourceCharacteristicItemShort("status.Health", CapifInvokerState.MISSING.name() ,  EValueType.TEXT.getValue());
    
    Resource res = aCatalogClient.updateResourceById( resourceid, resourceUpdate);
    
    return res;
  }
  
  
  public void processBearerRefreshTokens() {
    //update all the bearers and passes it back to the resources
    for (Entry<String, CapifInvokerResource> res : resourceToInvokerMap.entrySet() ) {
      
      CapifInvoker onboardedInvoker = invokerManagement.refreshBearer(res.getValue() .getRefCapifInvoker() );
      ResourceUpdate resourceUpdate = new ResourceUpdate();
      
      resourceUpdate.addResourceCharacteristicItemShort("bearerAccessToken",  onboardedInvoker.getBearerAccessToken() , EValueType.TEXT.getValue());

      resourceUpdate.addResourceCharacteristicItemShort("status.infoMessage", "Bearer token refreshed " + (new Date()) ,  EValueType.TEXT.getValue());
      String resourceid = res.getKey() ;
      aCatalogClient.updateResourceById( resourceid , resourceUpdate);
      
      
    }
    
    
  }
  
  
  
}
