package org.etsi.osl.controllers.capif.invoker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.etsi.osl.controllers.capif.invoker.SpringCapifInvokersConfig.Invoker;
import org.etsi.osl.controllers.capif.invoker.SpringCapifInvokersConfig.Invoker.ApiName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Service;


@Service
@Configuration
public class InvokerManagement {
  

  private static final Logger logger = LoggerFactory.getLogger("org.etsi.osl.controllers.capif.invoker");
  
//  Map<String, CapifInvoker> concurrentHashMap = new ConcurrentHashMap<>();

  private final SpringCapifInvokersConfig config;

  /**
   * this list contains all the configured invokers (from application.yaml externally)
   */
  Map<String, CapifInvoker> availableInvokers = new ConcurrentHashMap<>();

  
  /**
   * This map contains all the onboarded Invokers to the CAPIF service
   * Key is the invoker name
   */
  Map<String, CapifInvoker> onboardedInvokers = new ConcurrentHashMap<>();
  
  
  @Autowired
  CapifService aCapifService;
    
  @Autowired
  public InvokerManagement(SpringCapifInvokersConfig config) {
      this.config = config;
  }

  
  public Map<String, CapifInvoker> loadInvokers() {
    logger.info("=== loadInvokers ===");
    availableInvokers.clear();
    
    for ( Invoker inv : config.getInvokers() ) {
      
      CapifInvoker ci = new CapifInvoker();
      ci.setName( inv.getName());
      ci.setPrivateKey(inv.getPrivatekey());
      ci.setPublicKey(inv.getPublickey());
      ci.setDescription( inv.getDescription() );
      
      for ( ApiName apiname : inv.getApinames()) {
        ci.getReqApiNames().add( apiname.getApi() );
      }

      ci.setCapifInvokerState( CapifInvokerState.CONFIGURED );
      availableInvokers.put( ci.getName(), ci);
      
    }
    return availableInvokers;
    
  }
  

  public CapifInvoker onboardInvokerByName(String invokerName) throws Exception {
     
    CapifInvoker cif = availableInvokers.get(invokerName);
    if ( cif!=null) {
      logger.info("=== onboardInvokerByName {}  ===", cif.getName());
      
      CapifInvoker resultInv =  onboardedInvokers.get(cif.getName());      
      if ( resultInv == null ) { //onboard it
        resultInv = aCapifService.onboardInvoker( cif );
        aCapifService.discoverallServiceAPIs( resultInv );
        cif = aCapifService.putSecurityContext( resultInv );
      }
      
      cif = aCapifService.getServiceBearer( resultInv );
      //aCapifService.fetchURL(cif);
      
      onboardedInvokers.put(cif.getName() , cif);
      
      return cif;    
    }
    
    
    return null;
  }
  
  public CapifInvoker refreshBearer(CapifInvoker cif) {

    CapifInvoker resultInv =  onboardedInvokers.get(cif.getName());      
    try {
      logger.info("Previous bearer: " + cif.getBearerAccessToken());
      cif = aCapifService.getServiceBearer( resultInv );
      logger.info("new bearer: " + cif.getBearerAccessToken());
    } catch (Exception e) {
      e.printStackTrace();
    }
    return cif;
    
  }
  
  
  
  
  public CapifInvoker updateInvoker(CapifInvoker cif) {
    return cif;
    
  }
  
  
  public Boolean deleteInvoker(CapifInvoker cif) {
    
    return false;
    
  }

  
  
}
