package org.etsi.osl.controllers.capif.invoker;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.etsi.osl.domain.model.DomainModelDefinition;
import org.etsi.osl.domain.model.ITMFRCM634_ModelTransformer;
import org.etsi.osl.domain.model.ITMFRI639_ModelTransformer;
import org.etsi.osl.tmf.common.model.Any;
import org.etsi.osl.tmf.common.model.ELifecycle;
import org.etsi.osl.tmf.common.model.EValueType;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationCharacteristic;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationCharacteristicValue;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationCreate;
import org.etsi.osl.tmf.ri639.model.Characteristic;
import org.etsi.osl.tmf.ri639.model.ResourceCreate;
import org.etsi.osl.tmf.ri639.model.ResourceStatusType;
import org.etsi.osl.tmf.ri639.model.ResourceUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;

/**
 * This wraps a CAPIF Invoker as a Resource.
 * We have a new Resource reflecting an existing CAPIFInvoker. 
 * In current design a CAPIFInvoker might be reused by many resources.
 * In future approaches and for use cases supporting different authentication means, we might need a one-to-one mapping
 * 
 */


public class CapifInvokerResource  extends DomainModelDefinition
implements ITMFRCM634_ModelTransformer, ITMFRI639_ModelTransformer {
  
  private static final Logger logger = LoggerFactory.getLogger("org.etsi.osl.controllers.capif.invoker");
  
  public static final String OSL_RSPEC_TYPE = "LogicalResourceSpecification";
  
  private String healthStatus="NA";
  
  @Autowired
  static CatalogClient aCatalogClient;
  
  CapifInvoker refCapifInvoker;
  
  public CapifInvokerResource( String invokerName, String version, String description,
      String category, CapifInvoker refCapifInvoker) {
    super("",  invokerName, version, description, category);
    this.refCapifInvoker = refCapifInvoker;
  }

  
  
  @Override
  public ResourceSpecificationCreate toRSpecCreate_InitRepo() {

    ResourceSpecificationCreate rsc = new ResourceSpecificationCreate();
    
    rsc.setName( this.name );
    rsc.setVersion( this.version );
    rsc.setDescription( this.description );
    rsc.setType( OSL_RSPEC_TYPE );
    rsc.setCategory( this.category);
    
    rsc.setLifecycleStatus( ELifecycle.ACTIVE.getValue() );


    
    ResourceSpecificationCharacteristic ci = addResourceSpecificationCharacteristicItemShort("bearerAccessToken", refCapifInvoker.getBearerAccessToken() , EValueType.TEXT.getValue(), description , "", false);    
    rsc.addResourceSpecificationCharacteristicItem(ci);
    

    int i=0;
    for (String reqApiName : refCapifInvoker.getReqApiNames()) {
      ci = addResourceSpecificationCharacteristicItemShort("reqApiNames_" +i , reqApiName, EValueType.TEXT.getValue(), description , "", false);    
      rsc.addResourceSpecificationCharacteristicItem(ci);
      i++;
      
    }
    
    ci = addResourceSpecificationCharacteristicItemShort("status.discoveredServiceAPIs", refCapifInvoker.getDiscoveredServiceAPIs()  , EValueType.TEXT.getValue(), description , "", false);    
    rsc.addResourceSpecificationCharacteristicItem(ci);
    
    

    ci = addResourceSpecificationCharacteristicItemShort("status.state", refCapifInvoker.getCapifInvokerState().name() ,  EValueType.TEXT.getValue(), description , "", false);    
    rsc.addResourceSpecificationCharacteristicItem(ci);
    ci = addResourceSpecificationCharacteristicItemShort("status.infoMessage", healthStatus,  EValueType.TEXT.getValue(), description , "", false);    
    rsc.addResourceSpecificationCharacteristicItem(ci);
    
    
    return rsc;
  }
  

  /**
   * @param name
   * @param defaultValue
   * @param valueType
   * @param description
   * @param isConfigurable
   * @return
   */
  public ResourceSpecificationCharacteristic addResourceSpecificationCharacteristicItemShort(
          String name,
          String defaultValue,
          String valueType,
          String description,
          String regex,
          Boolean isConfigurable) {
      
      
      ResourceSpecificationCharacteristic ci = new ResourceSpecificationCharacteristic();
      ci
      .name( name )
      .description(description)
      .valueType(valueType);
      if (defaultValue!=null) {
          ResourceSpecificationCharacteristicValue val = new ResourceSpecificationCharacteristicValue();
          val.setValue( new Any( defaultValue, null) );
          val.isDefault(true);
          ci.getResourceSpecCharacteristicValue().add( val );         
      }   
      ci.configurable( isConfigurable );
      ci.regex(regex);
      return ci;
  }
  


  @Override
  public DomainModelDefinition fromRSpec(ResourceSpecification rSpec) {
    // TODO Auto-generated method stub
    return null;
  }
  
  
  

  /**
   * @return the refCapifInvoker
   */
  public CapifInvoker getRefCapifInvoker() {
    return refCapifInvoker;
  }


  /**
   * @param refCapifInvoker the refCapifInvoker to set
   */
  public void setRefCapifInvoker(CapifInvoker refCapifInvoker) {
    this.refCapifInvoker = refCapifInvoker;
  }



  
  
  
  
}
