package org.etsi.osl.controllers.capif.invoker;

import java.net.URL;
import java.util.List;
import java.util.Map;
import org.etsi.osl.tmf.common.model.Any;
import org.etsi.osl.tmf.pm632.model.Characteristic;
import org.etsi.osl.tmf.pm632.model.Organization;
import org.etsi.osl.tmf.pm632.model.OrganizationAttributeValueChangeEvent;
import org.etsi.osl.tmf.rcm634.model.LogicalResourceSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRef;
import org.etsi.osl.tmf.ri639.model.Resource;
import org.etsi.osl.tmf.ri639.model.ResourceCreate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import jakarta.annotation.PreDestroy;
import lombok.Data;

/**
 * @author ctranoris
 */
@Service
public class BootstrapService {

	private static final Logger logger = LoggerFactory.getLogger("org.etsi.osl.controllers.capif.invoker");


    
    @Autowired
    CatalogClient catalogClient;
    

    @Autowired
    InvokerManagement invokerManagement;
    
    
    @Autowired
    CapifService aCapifService;
    
    @Value("${osl-controller.category}")
    private String compcategory;

    @Value("${osl-controller.version}")
    private String compversion;
    
    @Autowired
    private ApplicationContext context;

	/**
	 * This one is executed when the cridge service application starts
	 * 
	 * It creates here a default model in OSL TMF
	 * Create any related Logical resource specifications
	 * 
	 * 
	 * @param event
	 * @throws Exception 
	 */
	@EventListener(ApplicationStartedEvent.class)
	public void onApplicationEvent()  {


	  //Register first to CAPIF service
	  try {
      aCapifService.authorizeToCapifService();
    } catch (Exception e) {      
      e.printStackTrace();
      logger.error( "Cannot connect and authorize to CAPIF Server" );
      int exitCode = SpringApplication.exit(context, () ->  1);
      System.exit(exitCode);
      
    }	  
	  
	  //after a successful authorization we need to register a Resource Specification per Invoker name
	  
	  Map<String, CapifInvoker>  availableInvokers = invokerManagement.loadInvokers();
	  for (CapifInvoker capifInvoker : availableInvokers.values() ) {
	      CapifInvokerResource rspec = new CapifInvokerResource( capifInvoker.getName(), compversion , 
	          capifInvoker.getDescription() , compcategory, capifInvoker);
	      LogicalResourceSpecification lrs = catalogClient.createOrUpdateResourceSpecByNameCategoryVersion( rspec.toRSpecCreate_InitRepo() );        

	      logger.info( "Registered LogicalResourceSpecification to repository: " + lrs.getId() );
	  }
	  
	  
	  logger.info( "Bootstrap process finished. Waiting for Invoker requests." );
	  
	}






	@PreDestroy
	private void stop() {
		logger.info("Closing due to ContextStoppedEvent ");
	}
}
