package org.etsi.osl.controllers.capif.invoker;

import java.util.ArrayList;
import java.util.List;
import lombok.Data;

@Data
public class ApiResponse {


  private List<ServiceAPIDescription> serviceAPIDescriptions;

  public List<ServiceAPIDescription> getServiceAPIDescriptions() {
    return serviceAPIDescriptions;
  }

  public void setServiceAPIDescriptions(List<ServiceAPIDescription> serviceAPIDescriptions) {
    this.serviceAPIDescriptions = serviceAPIDescriptions;
  }


  @Data
  public static class ServiceAPIDescription {
    private String apiName;
    private String apiId;
    private ApiStatus apiStatus;
    private List<AefProfile> aefProfiles;
    private String description;
    private String supportedFeatures;
    private ShareableInfo shareableInfo;
    private String serviceAPICategory;
    private String apiSuppFeats;
    private PubApiPath pubApiPath;
    private String ccfId;

    // Getters and setters ...
  }

  @Data
  public static class ApiStatus {
    private List<String> aefIds;

    public List<String> getAefIds() {
      return aefIds;
    }

    public void setAefIds(List<String> aefIds) {
      this.aefIds = aefIds;
    }
  }


  @Data
  public static class AefProfile {
    private String aefId;
    private List<Version> versions;
    private String protocol;
    private String dataFormat;
    private List<String> securityMethods;
    private List<InterfaceDescription> interfaceDescriptions;

    // Getters and setters ...
  }

  @Data
  public static class Version {
    private String apiVersion;
    private String expiry;
    private List<Resource> resources;
    private List<CustOperation> custOperations;

    // Getters and setters ...
  }

  @Data
  public static class Resource {
    private String resourceName;
    private String commType;
    private String uri;
    private String custOpName;
    private List<String> operations;
    private String description;

    // Getters and setters ...
  }

  @Data
  public static  class CustOperation {
    private String commType;
    private String custOpName;
    private List<String> operations;
    private String description;

    // Getters and setters ...
  }

  @Data
  public static class InterfaceDescription {
    private String ipv4Addr;
    private int port;
    private List<String> securityMethods;

    // Getters and setters ...
  }

  @Data
  public static class ShareableInfo {
    private boolean isShareable;
    private List<String> capifProvDoms;
    public boolean isIsShareable() {
      return isShareable;
  }

    public void setIsShareable(boolean isShareable) {
        this.isShareable = isShareable;
    }
  }

  public static class PubApiPath {
    private List<String> ccfIds;

    public List<String> getCcfIds() {
      return ccfIds;
    }

    public void setCcfIds(List<String> ccfIds) {
      this.ccfIds = ccfIds;
    }
  }

}


