
# CAMARAaaS Add-on

The **CAMARA as a Service OSL Add-on** allows telecom operators and customer service providers to expose OSL services through CAMARA APIs. By doing so, it enables runtime operations, such as enforcing profiles on User Equipment (UEs) or updating 5G Network Slice characteristics, using standardized CAMARA API endpoints. Thus, this add-on enables the orchestration of CAMARA APIs, which will then be used to control the lifecyle and the operations that shall take place in an already existing OSL Service.

Therefore, these are the key features of this add-on:

- **Seamless Integration**: Operators can expose their existing OSL services through CAMARA APIs, maintaining consistency with the OSL framework while offering additional accessibility.
- **Dynamic Service Control**: Allows runtime updates to characteristics of 5G-related Services, such as UE profiles or Network Slices, via CAMARA REST API calls. The updated of the characteristics of a Service can then be consumed by a Kubernetes Custom Resource that will produce an operation according to the updated characteristics.

## Architecture and Interactions

The add-on introduces a generic **CAMARA API Service**, which acts as a wrapper for existing (running)  services. The architecture ensures:

1. **API Exposure**: CAMARA APIs are orchestrated by OSL (offered as a service) and their endpoints are exposed to the end clients.
2. **Service Mapping**: The CAMARA API Service references a running service (identified by a UUID), enabling targeted operations. The invoking of CAMARA API endpoints will results in updates in the running service’s characteristics.
3. **Operational Flow**: Updates triggered via CAMARA APIs are propagated to the operator's service through OSL0s message queue (Active MQ), ensuring synchronization of service characteristics.

This architecture is presented in the figure below:

![CAMARAaaS-Architecture](Documentation/CAMARAaaS-Architecture.png)

As already mentioned, the step “PATCH Characteristics” is achieved by send a message to OSL’s message bus.

For OSL’s community to get the full grasp of this architecture, we also make available a sequence diagram with all interactions that take place.

![CAMARAaaS-Workflow-OSLToday](Documentation/CAMARAaaS-Workflow-OSLToday.png)

![CAMARAaaS-Workflow-ServiceOrdering](Documentation/CAMARAaaS-Workflow-ServiceOrdering.png)

![CAMARAaaS-Workflow-ServiceOperation](Documentation/CAMARAaaS-Workflow-ServiceOperation.png)
## Important Considerations

The OSL CAMARA as a Service Add-on depends on 2 Services:

- The OSL CAMARA API Service
    - Is a generic CAMARA API wrapper service implemented by the OSL team
    - This implementation will be publicly offered as an Addon (Helm chart)
- A custom 5G-related Service (that shall be controlled/referenced by the CAMARA API Service):
    - An OSL user must implement and provide its own 5G-related Controlling Service (following OSL design patterns)
    - Implementation is custom

