
# CAMARAaaS Add-on

The **CAMARA as a Service OSL Add-on** is a prototype service developed by OSL and allows users of OSL to expose CAMARA APIs for their TMF based services. By doing so, it enables runtime operations, such as enforcing profiles on User Equipment (UEs) or updating 5G Network Slice characteristics, using standardized CAMARA API endpoints. The work is in progress for future enhancments (e.g. multitenancy, etc). 

In a nutchel CAMARAaaS add-on makes API transformations from CAMARA API model to TMF API model and vice-versa.

The supporintg use case is the following:

- An OSL Service provider (e.g. an Operator) has a running 5G core (e.g. from another service order in OSL)
- The running service exposes already some characteristics (i.e. via TMF Service inventory) that can be configured and thus one can reconfigure it. (e.g. change the quality of a slice via a TMF API service request)
- On a subsequent step, the service provider makes a service order in OSL to expose this running service via a CAMARA API endpoint
- The CAMARAaaService add-on is a wrapper between the CAMARA requests and the TMF API service inventory models. These CAMARA APIs will then be used to control the lifecyle and the operations that shall take place in an already existing OSL Service.

Therefore, these are the key features of this add-on:

- **Seamless Integration**: Operators can expose their existing OSL services through CAMARA APIs, maintaining consistency with the OSL framework while offering additional accessibility.
- **Dynamic Service Control**: Allows runtime updates to characteristics of 5G-related Services, such as UE profiles or Network Slices, via CAMARA REST API calls. The updated characteristics of a Service can then be consumed by a Kubernetes Custom Resource that will produce an operation according to the updated characteristics.

## Architectural approach and service interactions

The add-on introduces a generic **CAMARA API Service**, which acts as a wrapper for existing (running) services registered in TMF Service Inventory. The architecture ensures:

1. **API Exposure**: CAMARA APIs are orchestrated by OSL (offered as a service) and their endpoints are exposed to the end clients.
2. **Service Mapping**: The CAMARA API Service references a running service (identified by a UUID), enabling targeted operations. The invoking of CAMARA API endpoints will results in updates in the running service’s characteristics.
3. **Operational Flow**: Updates triggered via CAMARA APIs are propagated to the operator's service through OSL's message queue (Active MQ), ensuring synchronization of service characteristics.

This architectural approach is presented in the figure below:

![CAMARAaaS-Architecture](Documentation/CAMARAaaS-Architecture.png)

### **Components in the Architecture**

1. **Service Specification Catalogue**:
   - Stores the service specifications.
   - Contains the `CAMARA API Controller` service specification, which defines the profile enforcer functionality.

2. **Service Inventory Catalogue**:
   - Tracks service instances (e.g., RFS - Resource-Facing Services) and their configurations.
   - Includes services such as:
     - CAMARA API Exposure Profile Enforcer.
     - 5G Network Slice.
     - Network profiles and UE (User Equipment) services.

3. **Resource Inventory Catalogue**:
   - Holds information about resources provisioned in the system.
   - Contains resources like:
     - CAMARA API Exposure.
     - Profile Enforcer.
     - 5G Core
     - Configmaps (used for managing Kubernetes configurations).

4. **Kubernetes Cluster**:
   - Hosts and manages the 5G Core components.
   - Hosts all our operators (OSL can manage all these through CRIDGE - not depicted)
   - Facilitates configuration updates via ConfigMap and resource values.

5. **CAMARA API Controller**:
   - Processes API exposure requests and orchestrates resources for API exposure.
   - Generates the CAMARA API Exposure resource on demand.

---

### **Processes in the Workflow**

There are two workflows depicted

1. **Service Order Creation**:
   - A service order is initiated to expose a service CAMARA API Exposure with parameter(`ExposeServiceUUID=Profile Enforcer`) using the TMF Service order API.
   - This triggers the service provisioning process in the Service Inventory Catalogue.
   - A custom resource is created and request via the CAMARA API controller to create the CAMARA API Exposure for Service Profile Enforcer
   - The `CAMARA API Exposure` resource is created and populated with configuration values.
   - The API Exposure is finalized and made available for consumption via the CAMARA API Exposure created service in the cluster.


2. **CAMARA API Usage**:
   - The API request includes QoD (Quality of Delivery) parameters and is accessible via a specified NodePort and endpoint URL e.g. (`portal.osl/{serviceAUUID}/camaraapiFQDN`).
   -  A client makes a CAMARA QoD Request
   -  TMF request is used to patch and customize Profile enforcer service configurations in the inventory
   -  This is passed through OSL orchestrator and CRIDGE down to The `5G Core Controller` 
   -  The `5G Core Controller` modifies configurations such as:
     - Slices (5G Network Slice profiles).
     - User equipment (UE) profiles.
     - These changes are propagated to the Kubernetes-managed 5G Core components.
- Resources in the Resource Inventory Catalogue are updated to reflect the service requirements.
- Updates are made to the `Configmap` resource to align with the latest service configurations.
- These changes ensure the 5G Core components operate with updated slice, profile, and UE configurations.
---

This architecture emphasizes automation, modularity, and interoperability between CAMARA APIs and 5G Core infrastructure, leveraging Kubernetes for seamless management and deployment.

The first image below, displays how normally one can use OSL to deploy and change a running service deployed in a Kubernetes cluster, using Kubernetes CRDs. First the service is requested through a Service Order. For example the service is a Service Specification bundle consisting of:
- a 5GCore Service Specification that will deploy a 5G core through HELM charts
- a 5GController Service Specification (deployed via HELM) that can chage configuration of slices for UEs. This Controller might register further Kubernetes operators for reconfiguring the core, slices, etc. This 5Gontroller is developed by the service provider able to  reconfigure via e.g. NEF, scripting, API commands or other means.

OSL via a service order deploys the services. Then while the service is in operation (ACTIVE), the user that ordered it can reconfigure it (see loop in figure) by changing characteristics of the sevice. These characteristics are then propagated from OSL orchestrator, through CRIDGE, down to the 5GController kubernetes resource to handle it.

![CAMARAaaS-Workflow-OSLToday](Documentation/CAMARAaaS-Workflow-OSLToday.png)

Since we have the service running in previous step, we request to expose it via a certain CAMARA API. We order the CAMARA controller to expose this service via CAMARA API, we just need to pass during the Service Order the UUID identifier of the service in TMF Service Inventory.

![CAMARAaaS-Workflow-ServiceOrdering](Documentation/CAMARAaaS-Workflow-ServiceOrdering.png)

Since we have now a new CAMRAS API service, clients can use this new API to reconfigure the service. This request is passed through the service bus to the TMF API and then down to the 5GController service.
As already mentioned, the step “PATCH Characteristics” is achieved by send a message to OSL’s message bus.


![CAMARAaaS-Workflow-ServiceOperation](Documentation/CAMARAaaS-Workflow-ServiceOperation.png)


## Important Considerations

The OSL CAMARA as a Service Add-on depends on 2 Services:

- The OSL CAMARA API Service
    - Is a generic CAMARA API wrapper service implemented by the OSL team
    - This implementation will be publicly offered as an Addon (Helm chart)
- A custom 5G-related Service (that shall be controlled/referenced by the CAMARA API Service):
    - An OSL user must implement and provide its own 5G-related Controlling Service (following OSL design patterns)
    - Implementation is custom

