# Swagger generated server

## Overview
This server was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project. By using the
[OpenAPI-Spec](https://github.com/swagger-api/swagger-core/wiki) from a remote server, you can easily generate a server stub.  This
is an example of building a swagger-enabled Flask server.

This example uses the [Connexion](https://github.com/zalando/connexion) library on top of Flask.

## Requirements
Python 3.5.2+

## Usage
To run the server, please execute the following from the root directory:

```
pip3 install -r requirements.txt
```
then replace the values in export_env_par.txt (pi-edge requires mongodb and postgres instances)
and execute:


```
source export_env_par.txt
python3 -m swagger_server
```

and open your browser to here:

```
http://localhost:8080/piedge-connector/2.0.0
```

Your Swagger definition lives here:

```
http://localhost:8080/piedge-connector/2.0.0/swagger.json
```

To launch the integration tests, use tox:
```
sudo pip install tox
tox
```

## Running with Docker

To run the server on a Docker container, please execute the following from the root directory:

```bash
# building the image
docker build -t swagger_server .

# starting up a container
docker run -p 8080:8080 swagger_server
```


## Running with K8S

Go to deployment_files folder, replace ENV parameters in piedge_deploy_generic.yaml file and execute:
```
kubectl create namespace pi-edge-system
kubectl apply -f piedge_deploy_tandem.yaml -n pi-edge-system
```
Note:
Prometheus and Grafana should be available in monitoring namespace, if not please deploy them using the following url:
https://devopscube.com/setup-prometheus-monitoring-on-kubernetes/