import os
from pydantic.v1 import BaseSettings
from dotenv import load_dotenv

load_dotenv()


class Configuration(BaseSettings):
    MONGO_URI: str = os.getenv("MONGO_URI")
    SRM_HOST: str = os.getenv("SRM_HOST")
    PI_EDGE_USERNAME: str = os.getenv("PI_EDGE_USERNAME")
    PI_EDGE_PASSWORD: str = os.getenv("PI_EDGE_PASSWORD")
    HTTP_PROXY: str = os.getenv("HTTP_PROXY")
    FEDERATION_MANAGER_HOST=os.getenv("FEDERATION_MANAGER_HOST")
    TOKEN_ENDPOINT = os.getenv('TOKEN_ENDPOINT')
    PARTNER_API_ROOT = os.getenv('PARTNER_API_ROOT')


config = Configuration()
