# Open Exposure Gateway

A Server Implementation of the **CAMARA Edge Application Management API** as specified [here](https://github.com/camaraproject/EdgeCloud/blob/main/code/API_definitions/Edge-Application-Management.yaml)


### Overview


[![Edge Cloud Management API](https://labs.etsi.org/rep/oop/code/open-exposure-gateway/badges/dev-branch/pipeline.svg)](https://labs.etsi.org/rep/oop/code/open-exposure-gateway/-/pipelines)

This server was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.
It uses the [Connexion](https://github.com/zalando/connexion) library on top of Flask.
It propagates requests to the [Sunrise 6G OP service resource manager](https://github.com/OpenOperatorPlatform/service_resource_manager), as configured in the `.env`.

### Usage
Before running the server you need to `mv env.sample .env` and update variables to properly link to a running OP service resource manager instance.

To run the server, please execute the following from the root directory:

Using uv: 
```bash
# run the server as module - uv will automatically take care of any dependencies installation
uv run edge_cloud_management_api
```
and open your browser to the OpenAPI documentation: `http://127.0.0.1:8080/docs/`

### Testing

To launch the integration tests, use tox:
```bash
uv run tox
```

### Running with Docker

To run the server on a Docker container, please execute the following from the root directory:

```bash
# building the image
docker build -t edge_cloud_management_api .

# starting up a container
docker run -p 8080:8080 --env-file ./.env edge_cloud_management_api
```
